/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.test;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.capture.Capture;
import io.github.mortuusars.exposure.client.capture.action.CaptureAction;
import io.github.mortuusars.exposure.client.capture.palettizer.Palettizer;
import io.github.mortuusars.exposure.client.gui.screen.test.ShutterSpeedSlider;
import io.github.mortuusars.exposure.client.gui.screen.test.Slider;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7940;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TestImageScreen
extends class_437 {
    protected float scale = 1.0f;
    protected boolean isCapturing;
    @Nullable
    protected Image image;
    @Nullable
    protected RenderableImage renderableImage;
    protected List<class_339> rightPaneWidgets = new ArrayList<class_339>();
    protected Slider sizeSlider;
    protected ShutterSpeedSlider shutterSpeedSlider;
    protected Slider exposureSlider;
    protected Slider contrastSlider;
    protected Slider shadowsSlider;
    protected Slider midtonesSlider;
    protected Slider highlightsSlider;
    protected Slider blackSlider;
    protected Slider whiteSlider;
    protected Slider balanceRedSlider;
    protected Slider balanceGreenSlider;
    protected Slider balanceBlueSlider;
    protected Slider hueSlider;
    protected Slider saturationSlider;
    protected Slider brightnessSlider;
    protected Slider noiseSlider;
    protected class_4286 bw;
    protected class_4286 aged;
    protected float rightPaneScroll = 0.0f;
    protected long applyEditsAt = -1L;

    public TestImageScreen() {
        super((class_2561)class_2561.method_43473());
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        int sliderWidth = 120;
        int sliderHeight = 15;
        int spacingInGroup = 1;
        int spacingBetweenGroups = 4;
        int screenEdgeMargin = 5;
        int labelXOffset = 3;
        int x = this.field_22789 - sliderWidth - screenEdgeMargin;
        int labelX = x + labelXOffset;
        int y = screenEdgeMargin;
        this.rightPaneWidgets.clear();
        this.sizeSlider = new Slider(x, y, sliderWidth, sliderHeight, 320.0, 1.0, 2048.0, 0, "Size", v -> this.onChanged());
        this.method_37063((class_364)this.sizeSlider);
        this.rightPaneWidgets.add(this.sizeSlider);
        y += this.sizeSlider.method_25364();
        class_7940 toneLabel = new class_7940(labelX, y += spacingBetweenGroups, (class_2561)class_2561.method_43470((String)"Tone"), this.field_22793);
        this.method_37060((class_4068)toneLabel);
        this.rightPaneWidgets.add((class_339)toneLabel);
        Objects.requireNonNull(this.field_22793);
        this.shutterSpeedSlider = new ShutterSpeedSlider(x, y += 9, sliderWidth, sliderHeight, "Shutter Speed", Exposure.Items.CAMERA.get().getAvailableShutterSpeeds(), ShutterSpeed.DEFAULT, v -> this.onChanged());
        this.shutterSpeedSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.method_37063((class_364)this.shutterSpeedSlider);
        this.rightPaneWidgets.add(this.shutterSpeedSlider);
        y += this.shutterSpeedSlider.method_25364();
        this.exposureSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -4.0, 4.0, 2, "Sensitivity", v -> this.onChanged());
        this.exposureSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.method_37063((class_364)this.exposureSlider);
        this.rightPaneWidgets.add(this.exposureSlider);
        y += this.exposureSlider.method_25364();
        this.contrastSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Contrast", v -> this.onChanged());
        this.contrastSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.method_37063((class_364)this.contrastSlider);
        this.rightPaneWidgets.add(this.contrastSlider);
        y += this.contrastSlider.method_25364();
        class_7940 levelsLabel = new class_7940(labelX, y += spacingBetweenGroups, (class_2561)class_2561.method_43470((String)"Levels"), this.field_22793);
        this.method_37060((class_4068)levelsLabel);
        this.rightPaneWidgets.add((class_339)levelsLabel);
        Objects.requireNonNull(this.field_22793);
        this.shadowsSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, 0.0, 255.0, 0, "Shadows", v -> this.onChanged());
        this.shadowsSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.method_37063((class_364)this.shadowsSlider);
        this.rightPaneWidgets.add(this.shadowsSlider);
        y += this.shadowsSlider.method_25364();
        this.midtonesSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 128.0, 0.0, 255.0, 0, "Midtones", v -> this.onChanged());
        this.midtonesSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.method_37063((class_364)this.midtonesSlider);
        this.rightPaneWidgets.add(this.midtonesSlider);
        y += this.shadowsSlider.method_25364();
        this.highlightsSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 255.0, 0.0, 255.0, 0, "Highlights", v -> this.onChanged());
        this.highlightsSlider.setHorizontalGradient(0x44FFFFFF, 0x44000000);
        this.method_37063((class_364)this.highlightsSlider);
        this.rightPaneWidgets.add(this.highlightsSlider);
        y += this.shadowsSlider.method_25364();
        this.blackSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, 0.0, 255.0, 0, "Black", v -> this.onChanged());
        this.blackSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.method_37063((class_364)this.blackSlider);
        this.rightPaneWidgets.add(this.blackSlider);
        y += this.shadowsSlider.method_25364();
        this.whiteSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 255.0, 0.0, 255.0, 0, "White", v -> this.onChanged());
        this.whiteSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.method_37063((class_364)this.whiteSlider);
        this.rightPaneWidgets.add(this.whiteSlider);
        y += this.shadowsSlider.method_25364();
        class_7940 hsbLabel = new class_7940(labelX, y += spacingBetweenGroups, (class_2561)class_2561.method_43470((String)"HSB"), this.field_22793);
        this.method_37060((class_4068)hsbLabel);
        this.rightPaneWidgets.add((class_339)hsbLabel);
        Objects.requireNonNull(this.field_22793);
        this.hueSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Hue", v -> this.onChanged());
        this.hueSlider.setHorizontalGradient(0x44FF0000, 0x44FF00FF);
        this.method_37063((class_364)this.hueSlider);
        this.rightPaneWidgets.add(this.hueSlider);
        y += this.shadowsSlider.method_25364();
        this.saturationSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Saturation", v -> this.onChanged());
        this.saturationSlider.setHorizontalGradient(0x44777777, 1157571089);
        this.method_37063((class_364)this.saturationSlider);
        this.rightPaneWidgets.add(this.saturationSlider);
        y += this.shadowsSlider.method_25364();
        this.brightnessSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Brightness", v -> this.onChanged());
        this.brightnessSlider.setHorizontalGradient(0x44000000, 0x44FFFFFF);
        this.method_37063((class_364)this.brightnessSlider);
        this.rightPaneWidgets.add(this.brightnessSlider);
        y += this.shadowsSlider.method_25364();
        class_7940 colorBalanceLabel = new class_7940(labelX, y += spacingBetweenGroups, (class_2561)class_2561.method_43470((String)"Color Balance"), this.field_22793);
        this.method_37060((class_4068)colorBalanceLabel);
        this.rightPaneWidgets.add((class_339)colorBalanceLabel);
        Objects.requireNonNull(this.field_22793);
        this.balanceRedSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Red", v -> this.onChanged());
        this.balanceRedSlider.setHorizontalGradient(0x4400FFFF, 0x44FF0000);
        this.method_37063((class_364)this.balanceRedSlider);
        this.rightPaneWidgets.add(this.balanceRedSlider);
        y += this.shadowsSlider.method_25364();
        this.balanceGreenSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Green", v -> this.onChanged());
        this.balanceGreenSlider.setHorizontalGradient(0x44FF00FF, 0x4400FF00);
        this.method_37063((class_364)this.balanceGreenSlider);
        this.rightPaneWidgets.add(this.balanceGreenSlider);
        y += this.shadowsSlider.method_25364();
        this.balanceBlueSlider = new Slider(x, y += spacingInGroup, sliderWidth, sliderHeight, 0.0, -1.0, 1.0, 2, "Blue", v -> this.onChanged());
        this.balanceBlueSlider.setHorizontalGradient(0x44FFFF00, 0x440000FF);
        this.method_37063((class_364)this.balanceBlueSlider);
        this.rightPaneWidgets.add(this.balanceBlueSlider);
        y += this.shadowsSlider.method_25364();
        class_7940 effectsLabel = new class_7940(labelX, y += spacingBetweenGroups, (class_2561)class_2561.method_43470((String)"Effects"), this.field_22793);
        this.method_37060((class_4068)effectsLabel);
        this.rightPaneWidgets.add((class_339)effectsLabel);
        Objects.requireNonNull(this.field_22793);
        this.noiseSlider = new Slider(x, y += 9, sliderWidth, sliderHeight, 0.0, 0.0, 1.0, 2, "Noise", v -> this.onChanged());
        this.noiseSlider.setHorizontalGradient(0x44777777, 0x44FFFFFF);
        this.method_37063((class_364)this.noiseSlider);
        this.rightPaneWidgets.add(this.noiseSlider);
        y += this.shadowsSlider.method_25364();
        this.bw = class_4286.method_54787((class_2561)class_2561.method_43470((String)"BW"), (class_327)this.field_22793).method_54789(x, y += spacingBetweenGroups).method_54791((checkbox, bl) -> this.onChanged()).method_54788();
        this.method_37063((class_364)this.bw);
        this.rightPaneWidgets.add((class_339)this.bw);
        this.aged = class_4286.method_54787((class_2561)class_2561.method_43470((String)"AGED"), (class_327)this.field_22793).method_54789(x + this.bw.method_25368() + 8, y).method_54791((checkbox, bl) -> this.onChanged()).method_54788();
        this.method_37063((class_364)this.aged);
        this.rightPaneWidgets.add((class_339)this.aged);
        class_4185 capture = class_4185.method_46430((class_2561)class_2561.method_43470((String)"CAPTURE"), b -> this.capture()).method_46437(60, 20).method_46433(screenEdgeMargin, this.field_22790 - 20 - screenEdgeMargin).method_46431();
        this.method_37063((class_364)capture);
        if (this.image == null) {
            this.capture();
        }
    }

    protected void capture() {
        if (this.isCapturing) {
            Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
            Minecrft.player().method_7353((class_2561)class_2561.method_43470((String)"Capture is in progress."), false);
            return;
        }
        this.isCapturing = true;
        Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Exposure.SoundEvents.SHUTTER_OPEN.get(), (float)1.0f));
        ExposureClient.cycles().enqueueTask(Capture.of(Capture.screenshot(), CaptureAction.hideGui()).handleErrorAndGetResult(err -> Minecrft.execute(() -> Minecrft.player().method_7353((class_2561)err.casual().method_27692(class_124.field_1061), false))).thenAsync(ImageEffect.Crop.SQUARE_CENTER::modify).onError(err -> Minecrft.execute(() -> Minecrft.player().method_7353((class_2561)err.casual().method_27692(class_124.field_1061), false))).accept(this::setImage));
    }

    protected void applyEdits() {
        if (this.renderableImage == null) {
            Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
            Minecrft.player().method_7353((class_2561)class_2561.method_43470((String)"No image to modify."), false);
            return;
        }
        try {
            this.renderableImage = RenderableImage.of("test_image", this.image).modifyWith(ImageEffect.Resize.to(this.sizeSlider.getValue().intValue())).modifyWith(ImageEffect.exposure(this.shutterSpeedSlider.getShutterSpeed().getBrightness() * (this.exposureSlider.getValue().floatValue() + 1.0f))).modifyWith(ImageEffect.contrast(this.contrastSlider.getValue().floatValue())).modifyWith(ImageEffect.levels(new Levels(this.shadowsSlider.getValue().intValue(), this.midtonesSlider.getValue().intValue(), this.highlightsSlider.getValue().intValue(), this.blackSlider.getValue().intValue(), this.whiteSlider.getValue().intValue()))).modifyWith(ImageEffect.hsb(this.hueSlider.getValue().floatValue(), this.saturationSlider.getValue().floatValue(), this.brightnessSlider.getValue().floatValue())).modifyWith(ImageEffect.colorBalance(this.balanceRedSlider.getValue().floatValue(), this.balanceGreenSlider.getValue().floatValue(), this.balanceBlueSlider.getValue().floatValue())).modifyWith(ImageEffect.noise(this.noiseSlider.getValue().floatValue())).modifyWith(ImageEffect.optional(this.bw.method_20372(), ImageEffect.BLACK_AND_WHITE)).modifyWith(image -> Palettizer.DITHERED.palettize((Image)image, (ColorPalette)ColorPalettes.getDefault(Minecrft.registryAccess()).comp_349()), "palette").modifyWith(ImageEffect.optional(this.aged.method_20372(), ImageEffect.AGED));
            ExposureClient.imageRenderer().clearCacheOf("test_image");
        }
        catch (Exception e) {
            Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
            Minecrft.player().method_7353((class_2561)class_2561.method_43470((String)("Failed to apply edits. " + e.getMessage())), false);
            Exposure.LOGGER.error("Failed to apply edits: ", (Throwable)e);
        }
        this.applyEditsAt = -1L;
    }

    protected void onChanged() {
        this.applyEditsAt = UnixTimestamp.Milliseconds.now();
    }

    private void setImage(Image image) {
        if (this.image != null) {
            this.image.close();
        }
        if (this.renderableImage != null) {
            this.renderableImage.close();
        }
        this.image = image;
        this.renderableImage = RenderableImage.of("test_image", image);
        this.applyEdits();
        ExposureClient.imageRenderer().clearCacheOf("test_image");
        Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Exposure.SoundEvents.SHUTTER_CLOSE.get(), (float)1.0f));
        this.isCapturing = false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.fillHorizontalGradient(guiGraphics, this.field_22789 - 100, -500, this.field_22789, this.field_22790 + 500, 0, -1156509423);
        if (this.isCapturing) {
            String txt = "Capturing...";
            guiGraphics.method_25303(this.field_22793, txt, this.field_22789 / 2 - this.field_22793.method_1727(txt) / 2, this.field_22790 / 2 - 4, -1);
            return;
        }
        if (this.renderableImage == null) {
            String txt = "<No Image>";
            guiGraphics.method_25303(this.field_22793, txt, this.field_22789 / 2 - this.field_22793.method_1727(txt) / 2, this.field_22790 / 2 - 4, -1);
            return;
        }
        if (this.applyEditsAt > 0L && UnixTimestamp.Milliseconds.now() >= this.applyEditsAt) {
            this.applyEdits();
        }
        guiGraphics.method_51448().method_22903();
        float size = (float)this.field_22790 * 0.8f * this.scale;
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f - size / 2.0f, (float)this.field_22790 / 2.0f - size / 2.0f, -100.0f);
        float borderPercent = 0.02f;
        guiGraphics.method_25294(class_3532.method_15375((float)(-size * borderPercent)), class_3532.method_15375((float)(-size * borderPercent)), class_3532.method_15386((float)(size + size * borderPercent)), class_3532.method_15386((float)(size + size * borderPercent)), -1);
        guiGraphics.method_51448().method_22905(size, size, size);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        ExposureClient.imageRenderer().render(this.renderableImage, guiGraphics.method_51448(), (class_4597)bufferSource, RenderCoordinates.DEFAULT, Color.WHITE);
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        int value = class_3532.method_17822((double)scrollY);
        if (mouseX > (double)(this.field_22789 - 100) && !this.rightPaneWidgets.isEmpty()) {
            int yChange = value * 14;
            if (yChange > 0 && this.rightPaneWidgets.getFirst().method_46427() >= 5) {
                return true;
            }
            if (yChange < 0 && this.rightPaneWidgets.getLast().method_46427() + this.rightPaneWidgets.getLast().method_25364() <= this.field_22790 - 5) {
                return true;
            }
            for (class_339 widget : this.rightPaneWidgets) {
                widget.method_46419(widget.method_46427() + yChange);
                if (widget.method_46427() < 5 || widget.method_46427() + widget.method_25364() > this.field_22790 - 5) {
                    widget.field_22764 = false;
                    continue;
                }
                widget.field_22764 = true;
            }
            return true;
        }
        this.scale = class_3532.method_15363((float)(this.scale + 0.2f * (float)value), (float)0.2f, (float)2.0f);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button != 1) {
            return false;
        }
        double fov = ((Integer)Minecrft.options().method_41808().method_41753()).intValue();
        int windowWidth = Minecrft.get().method_22683().method_4506();
        int windowHeight = Minecrft.get().method_22683().method_4506();
        double xRot = dragY / (double)windowHeight * fov;
        double yRot = dragX / (double)windowWidth * (fov * ((double)windowHeight / (double)windowWidth));
        Minecrft.player().method_5872(-yRot * 20.0, -xRot * 20.0);
        return true;
    }

    private void fillHorizontalGradient(class_332 guiGraphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        class_4588 consumer = guiGraphics.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        consumer.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_39415(colorFrom);
        consumer.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_39415(colorFrom);
        consumer.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_39415(colorTo);
        consumer.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_39415(colorTo);
    }
}

