/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import io.github.mortuusars.exposure.util.color.converter.HUSLColorConverter;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import org.apache.commons.lang3.StringUtils;

public class AgedHSLUVEffect
implements PixelEffect {
    protected final int tintColor;
    protected final double[] tintColorHsluv;
    protected final float tintOpacity;
    protected final int blackPoint;
    protected final int whitePoint;

    public AgedHSLUVEffect(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        String hexStr = StringUtils.leftPad((String)Integer.toHexString(tintColor & 0xFFFFFF), (int)6, (String)"0");
        this.tintColorHsluv = HUSLColorConverter.hexToHsluv("#" + hexStr);
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdentifier() {
        return "aged";
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = class_5253.class_5254.method_27762((int)colorARGB);
        int red = class_5253.class_5254.method_27765((int)colorARGB);
        int green = class_5253.class_5254.method_27766((int)colorARGB);
        int blue = class_5253.class_5254.method_27767((int)colorARGB);
        red = (int)class_3532.method_37959((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)class_3532.method_37959((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        blue = (int)class_3532.method_37959((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f});
        hsluv[0] = this.tintColorHsluv[0];
        hsluv[1] = this.tintColorHsluv[1];
        double[] rgb = HUSLColorConverter.hsluvToRgb(hsluv);
        int newRed = class_3532.method_15340((int)((int)class_3532.method_16436((double)this.tintOpacity, (double)red, (double)(rgb[0] * 255.0))), (int)0, (int)255);
        int newGreen = class_3532.method_15340((int)((int)class_3532.method_16436((double)this.tintOpacity, (double)green, (double)(rgb[1] * 255.0))), (int)0, (int)255);
        int newBlue = class_3532.method_15340((int)((int)class_3532.method_16436((double)this.tintOpacity, (double)blue, (double)(rgb[2] * 255.0))), (int)0, (int)255);
        return class_5253.class_5254.method_27764((int)alpha, (int)newRed, (int)newGreen, (int)newBlue);
    }

    public String toString() {
        return "AgedHSLUVPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

