/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.util;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.capture.CaptureShader;
import io.github.mortuusars.exposure.client.util.Minecrft;
import java.io.IOException;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import org.jetbrains.annotations.NotNull;

public class Shader {
    private static boolean suppressViewfinder = false;

    public static void process(@NotNull class_279 shader, @NotNull class_276 renderTarget) {
        try {
            class_2960 shaderLocation = class_2960.method_60654((String)shader.method_1260());
            class_279 tempShader = new class_279(Minecrft.get().method_1531(), (class_5912)Minecrft.get().method_1478(), renderTarget, shaderLocation);
            tempShader.method_1259(renderTarget.field_1482, renderTarget.field_1481);
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            tempShader.method_1258(Minecrft.get().method_60646().method_60636());
        }
        catch (IOException e) {
            Exposure.LOGGER.warn("Failed to load shader: {}", (Object)shader.method_1260(), (Object)e);
        }
        catch (JsonSyntaxException e) {
            Exposure.LOGGER.warn("Failed to parse shader: {}", (Object)shader.method_1260(), (Object)e);
        }
    }

    public static void setSuppressViewfinder(boolean suppress) {
        suppressViewfinder = suppress;
    }

    public static void processForGameRenderer() {
        if (!suppressViewfinder && CameraClient.viewfinder() != null) {
            CameraClient.viewfinder().shader().process();
        }
        if (CaptureShader.hasShader()) {
            CaptureShader.process();
        }
    }

    public static void resize(int width, int height) {
        if (CameraClient.viewfinder() != null) {
            CameraClient.viewfinder().shader().resize(width, height);
        }
        if (CaptureShader.hasShader()) {
            CaptureShader.resize(width, height);
        }
    }
}

