/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.commands.argument.ColorPaletteArgument;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.util.color.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PaletteCommand {
    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"palette").then(class_2170.method_9247((String)"export").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"palette", (ArgumentType)new ColorPaletteArgument()).then(class_2170.method_9247((String)"json").then(class_2170.method_9244((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.exportAsJson((class_2168)context.getSource(), ColorPaletteArgument.method_9443((CommandContext)context, (String)"palette"), StringArgumentType.getString((CommandContext)context, (String)"file_path")))))).then(class_2170.method_9247((String)"png").then(class_2170.method_9244((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.exportAsPng((class_2168)context.getSource(), ColorPaletteArgument.method_9443((CommandContext)context, (String)"palette"), StringArgumentType.getString((CommandContext)context, (String)"file_path")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"convert").then(class_2170.method_9247((String)"json_to_png").then(class_2170.method_9244((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.convertJsonToPng((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"file_path")))))).then(class_2170.method_9247((String)"png_to_json").then(class_2170.method_9244((String)"file_path", (ArgumentType)StringArgumentType.string()).executes(context -> PaletteCommand.convertPngToJson((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"file_path"))))));
    }

    private static int exportAsJson(class_2168 source, class_2960 paletteId, String filePath) {
        @Nullable ColorPalette palette = (ColorPalette)source.method_30497().method_30530(Exposure.Registries.COLOR_PALETTE).method_10223(paletteId);
        if (palette == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)(String.valueOf(paletteId) + " is not found.")));
            return 0;
        }
        try {
            PaletteCommand.savePaletteAsJson(palette, new File(filePath));
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Exporting palette '{}' failed: ", (Object)paletteId, (Object)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Exporting palette '" + String.valueOf(paletteId) + "' failed: " + e.getMessage())));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Exported palette '" + String.valueOf(paletteId) + "' to file ")).method_10852((class_2561)class_2561.method_43470((String)filePath).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))), true);
        return 0;
    }

    private static int exportAsPng(class_2168 source, class_2960 paletteId, String filePath) {
        @Nullable ColorPalette palette = (ColorPalette)source.method_30497().method_30530(Exposure.Registries.COLOR_PALETTE).method_10223(paletteId);
        if (palette == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)(String.valueOf(paletteId) + " is not found.")));
            return 0;
        }
        try {
            PaletteCommand.savePaletteAsPng(palette, new File(filePath));
            source.method_9226(() -> class_2561.method_43470((String)("Exported palette '" + String.valueOf(paletteId) + "' to file ")).method_10852((class_2561)class_2561.method_43470((String)filePath).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))), true);
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Exporting palette '{}' failed: ", (Object)paletteId, (Object)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Exporting palette '" + String.valueOf(paletteId) + "' failed: " + e.getMessage())));
        }
        return 0;
    }

    private static int convertJsonToPng(class_2168 source, String filePath) {
        try {
            File file = new File(filePath);
            ColorPalette palette = PaletteCommand.loadPaletteFromJson(file);
            PaletteCommand.savePaletteAsPng(palette, PaletteCommand.replaceExtension(file, "png"));
            source.method_9226(() -> class_2561.method_43470((String)("Converted palette '" + filePath + "' to png.")), true);
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Converting palette '{}' failed: ", (Object)filePath, (Object)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Converting palette '" + filePath + "' failed: " + e.getMessage())));
        }
        return 0;
    }

    private static int convertPngToJson(class_2168 source, String filePath) {
        try {
            File file = new File(filePath);
            BufferedImage image = ImageIO.read(file);
            Integer[] colors = new Integer[256];
            int addedCount = 0;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth() && addedCount <= 255; ++x) {
                    int color = image.getRGB(x, y);
                    if (Color.alpha(color) == 0) {
                        color = Color.TRANSPARENT.getARGB();
                    }
                    boolean alreadyAdded = false;
                    for (Integer addedColor : colors) {
                        if (addedColor == null || !addedColor.equals(color)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    colors[addedCount] = color;
                    ++addedCount;
                }
            }
            for (int i = addedCount; i < colors.length - 1; ++i) {
                colors[i] = Color.BLACK.getARGB();
            }
            if (colors[255] == null) {
                colors[255] = Color.TRANSPARENT.getARGB();
            }
            if (!colors[255].equals(Color.TRANSPARENT.getARGB())) {
                colors[255] = Color.TRANSPARENT.getARGB();
                source.method_9213((class_2561)class_2561.method_43470((String)("Corrected last color to be transparent in '" + filePath + "' palette.")));
            }
            ColorPalette palette = new ColorPalette(Arrays.stream(colors).mapToInt(Integer::intValue).toArray());
            try {
                PaletteCommand.savePaletteAsJson(palette, PaletteCommand.replaceExtension(file, "json"));
            }
            catch (Exception e) {
                Exposure.LOGGER.error("Cannot save converted palette '{}' failed: ", (Object)filePath, (Object)e);
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot save converted palette '" + filePath + "' failed: " + e.getMessage())));
                return 0;
            }
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Converting palette '{}' failed: ", (Object)filePath, (Object)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Converting palette '" + filePath + "' failed: " + e.getMessage())));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Converted palette '" + filePath + "' to json.")), true);
        return 0;
    }

    private static void savePaletteAsJson(ColorPalette palette, File file) throws IOException {
        JsonElement jsonElement = (JsonElement)ColorPalette.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)palette).getOrThrow();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(jsonElement);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
        }
    }

    private static void savePaletteAsPng(ColorPalette palette, File file) throws IOException {
        BufferedImage image = new BufferedImage(16, 16, 2);
        int[] colors = palette.colors();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                image.setRGB(x, y, colors[y * 16 + x]);
            }
        }
        ImageIO.write((RenderedImage)image, "png", file);
    }

    private static ColorPalette loadPaletteFromJson(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            ColorPalette colorPalette = (ColorPalette)((Pair)ColorPalette.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow()).getFirst();
            return colorPalette;
        }
    }

    private static File replaceExtension(File originalFile, String newExtension) {
        String originalPath = originalFile.getPath();
        int lastDotIndex = originalPath.lastIndexOf(46);
        String newPath = lastDotIndex == -1 ? originalPath + "." + newExtension : originalPath.substring(0, lastDotIndex) + "." + newExtension;
        return new File(newPath);
    }
}

