/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.color;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.class_3532;

public record Color(int a, int r, int g, int b) {
    public static final Codec<Color> CODEC = Codec.INT.xmap(Color::argb, Color::getARGB);
    public static final Codec<Color> HEX_STRING_CODEC = Codec.STRING.xmap(Color::fromHex, Color::asHexString);
    public static final Color WHITE = new Color(255, 255, 255, 255);
    public static final Color BLACK = new Color(255, 0, 0, 0);
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);

    public Color {
        Color.validate(a, r, g, b);
    }

    private static void validate(int a, int r, int g, int b) {
        boolean rangeError = false;
        Object badComponentString = "";
        if (a < 0 || a > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Alpha";
        }
        if (r < 0 || r > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Red";
        }
        if (g < 0 || g > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Green";
        }
        if (b < 0 || b > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + (String)badComponentString);
        }
    }

    public static Color argb(int a, int r, int g, int b) {
        return new Color(a, r, g, b);
    }

    public static Color argb(int argb) {
        return Color.argb(argb >>> 24, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public static Color rgb(int r, int g, int b) {
        return new Color(255, r, g, b);
    }

    public static Color rgb(int rgb) {
        return Color.rgb(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static Color abgr(int abgr) {
        return Color.argb(abgr >>> 24, abgr & 0xFF, abgr >> 8 & 0xFF, abgr >> 16 & 0xFF);
    }

    public static Color bgr(int bgr) {
        return Color.rgb(bgr & 0xFF, bgr >> 8 & 0xFF, bgr >> 16 & 0xFF);
    }

    public static Color argbF(float a, float r, float g, float b) {
        return Color.argb(Color.clamp((int)(a * 255.0f)), Color.clamp((int)(r * 255.0f)), Color.clamp((int)(g * 255.0f)), Color.clamp((int)(b * 255.0f)));
    }

    public static Color rgbF(float r, float g, float b) {
        return Color.rgb(Color.clamp((int)(r * 255.0f)), Color.clamp((int)(g * 255.0f)), Color.clamp((int)(b * 255.0f)));
    }

    public int getA() {
        return this.a;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public float getAF() {
        return (float)this.a / 255.0f;
    }

    public float getRF() {
        return (float)this.r / 255.0f;
    }

    public float getGF() {
        return (float)this.g / 255.0f;
    }

    public float getBF() {
        return (float)this.b / 255.0f;
    }

    public int getARGB() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public int getABGR() {
        return this.a << 24 | this.b << 16 | this.g << 8 | this.r;
    }

    public int getRGB() {
        return 0xFF000000 | this.r << 16 | this.g << 8 | this.b;
    }

    public int getBGR() {
        return 0xFF000000 | this.b << 16 | this.g << 8 | this.r;
    }

    public String asHexString() {
        return String.format("%08X", this.getARGB());
    }

    public Color withAlpha(int alpha) {
        return new Color(alpha, this.getR(), this.getG(), this.getB());
    }

    public Color withAlphaF(float alpha) {
        return new Color(Color.clamp((int)(alpha / 255.0f)), this.getR(), this.getG(), this.getB());
    }

    public Color add(Color other) {
        return Color.argb(Color.clamp(this.a + other.a), Color.clamp(this.r + other.r), Color.clamp(this.g + other.g), Color.clamp(this.b + other.b));
    }

    public Unbounded addUnbounded(Color other) {
        return new Unbounded(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public Unbounded addUnbounded(Unbounded other) {
        return new Unbounded(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public Color subtract(Color other) {
        return Color.argb(Color.clamp(this.a - other.a), Color.clamp(this.r - other.r), Color.clamp(this.g - other.g), Color.clamp(this.b - other.b));
    }

    public Unbounded subtractUnbounded(Color other) {
        return new Unbounded(this.r - other.r, this.g - other.g, this.b - other.b, this.a - other.a);
    }

    public Color multiply(double scalar) {
        return Color.argb(Color.clamp((int)((double)this.a * scalar)), Color.clamp((int)((double)this.r * scalar)), Color.clamp((int)((double)this.g * scalar)), Color.clamp((int)((double)this.b * scalar)));
    }

    public int squaredDifferenceTo(Color color) {
        int rDiff = Math.abs(this.r - color.r);
        int gDiff = Math.abs(this.g - color.g);
        int bDiff = Math.abs(this.b - color.b);
        return rDiff * rDiff + gDiff * gDiff + bDiff * bDiff;
    }

    public int squaredDifferenceTo(int argb) {
        int rDiff = Math.abs(this.r - Color.red(argb));
        int gDiff = Math.abs(this.g - Color.green(argb));
        int bDiff = Math.abs(this.b - Color.blue(argb));
        return rDiff * rDiff + gDiff * gDiff + bDiff * bDiff;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.a == color.a && this.r == color.r && this.g == color.g && this.b == color.b;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.a, this.r, this.g, this.b);
    }

    public static int alpha(int argb) {
        return argb >>> 24;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static float alphaF(int argb) {
        return (float)(argb >>> 24) / 255.0f;
    }

    public static float redF(int argb) {
        return (float)(argb >> 16 & 0xFF) / 255.0f;
    }

    public static float greenF(int argb) {
        return (float)(argb >> 8 & 0xFF) / 255.0f;
    }

    public static float blueF(int argb) {
        return (float)(argb & 0xFF) / 255.0f;
    }

    public static int pack(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int clamp(int channel) {
        return class_3532.method_15340((int)channel, (int)0, (int)255);
    }

    public static int ABGRtoARGB(int ABGR) {
        int a = ABGR >> 24 & 0xFF;
        int b = ABGR >> 16 & 0xFF;
        int g = ABGR >> 8 & 0xFF;
        int r = ABGR & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int ARGBtoABGR(int ARGB) {
        return Color.ABGRtoARGB(ARGB);
    }

    public static Color fromHex(String hexColor) {
        return Color.argb((int)Long.parseLong(hexColor.replace("#", ""), 16));
    }

    public record Unbounded(int r, int g, int b, int a) {
        public Unbounded multiply(double scalar) {
            return new Unbounded((int)((double)this.r * scalar), (int)((double)this.g * scalar), (int)((double)this.b * scalar), (int)((double)this.a * scalar));
        }

        public Color clamp() {
            return Color.argb(Color.clamp(this.a), Color.clamp(this.r), Color.clamp(this.g), Color.clamp(this.b));
        }
    }

    public static class HSB {
        public static int HSBtoRGB(float[] hsb) {
            Preconditions.checkArgument((hsb.length == 3 ? 1 : 0) != 0, (Object)"hsb is not correct. Must have 3 float values.");
            return HSB.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        }

        public static int HSBtoRGB(float hue, float saturation, float brightness) {
            int r = 0;
            int g = 0;
            int b = 0;
            if (saturation == 0.0f) {
                g = b = (int)(brightness * 255.0f + 0.5f);
                r = b;
            } else {
                float h = (hue - (float)Math.floor(hue)) * 6.0f;
                float f = h - (float)Math.floor(h);
                float p = brightness * (1.0f - saturation);
                float q = brightness * (1.0f - saturation * f);
                float t = brightness * (1.0f - saturation * (1.0f - f));
                switch ((int)h) {
                    case 0: {
                        r = (int)(brightness * 255.0f + 0.5f);
                        g = (int)(t * 255.0f + 0.5f);
                        b = (int)(p * 255.0f + 0.5f);
                        break;
                    }
                    case 1: {
                        r = (int)(q * 255.0f + 0.5f);
                        g = (int)(brightness * 255.0f + 0.5f);
                        b = (int)(p * 255.0f + 0.5f);
                        break;
                    }
                    case 2: {
                        r = (int)(p * 255.0f + 0.5f);
                        g = (int)(brightness * 255.0f + 0.5f);
                        b = (int)(t * 255.0f + 0.5f);
                        break;
                    }
                    case 3: {
                        r = (int)(p * 255.0f + 0.5f);
                        g = (int)(q * 255.0f + 0.5f);
                        b = (int)(brightness * 255.0f + 0.5f);
                        break;
                    }
                    case 4: {
                        r = (int)(t * 255.0f + 0.5f);
                        g = (int)(p * 255.0f + 0.5f);
                        b = (int)(brightness * 255.0f + 0.5f);
                        break;
                    }
                    case 5: {
                        r = (int)(brightness * 255.0f + 0.5f);
                        g = (int)(p * 255.0f + 0.5f);
                        b = (int)(q * 255.0f + 0.5f);
                    }
                }
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }

        public static float[] RGBtoHSB(int r, int g, int b, float[] output) {
            float hue;
            int cmin;
            int cmax = Math.max(r, g);
            if (b > cmax) {
                cmax = b;
            }
            if (b < (cmin = Math.min(r, g))) {
                cmin = b;
            }
            float brightness = (float)cmax / 255.0f;
            float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
            if (saturation == 0.0f) {
                hue = 0.0f;
            } else {
                float redc = (float)(cmax - r) / (float)(cmax - cmin);
                float greenc = (float)(cmax - g) / (float)(cmax - cmin);
                float bluec = (float)(cmax - b) / (float)(cmax - cmin);
                hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
                if ((hue /= 6.0f) < 0.0f) {
                    hue += 1.0f;
                }
            }
            output[0] = hue;
            output[1] = saturation;
            output[2] = brightness;
            return output;
        }

        public static float[] RGBtoHSB(int r, int g, int b) {
            return HSB.RGBtoHSB(r, g, b, new float[3]);
        }
    }
}

