/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.item;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class SilkLeashItem
extends class_1792 {
    public SilkLeashItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static int updateLeashStates(class_1309 leashOwner, class_1309 leashedEntity) {
        Map<class_1297, ISilkLeashState> updatedStates = SilkLeashItem.updateLeashStatesLocal(leashOwner, leashedEntity);
        if (!updatedStates.isEmpty()) {
            CACPacketHandler.SILK_LEASH_STATE.sendToTracking((class_1297)(leashOwner == null ? leashedEntity : leashOwner), new ClientboundSilkLeashStatePacket(updatedStates.entrySet().stream().map(entry -> new ClientboundSilkLeashStatePacket.LeashData(((class_1297)entry.getKey()).method_5628(), (IntList)new IntArrayList(((ISilkLeashState)entry.getValue()).getLeashingEntities().stream().mapToInt(class_1297::method_5628).toArray()), (IntList)new IntArrayList(((ISilkLeashState)entry.getValue()).getLeashedByEntities().stream().mapToInt(class_1297::method_5628).toArray()))).collect(Collectors.toList())));
        }
        return updatedStates.size();
    }

    public static Map<class_1297, ISilkLeashState> updateLeashStatesLocal(class_1309 leashOwner, class_1309 leashedEntity) {
        if (leashOwner == null && leashedEntity == null) {
            throw new IllegalArgumentException("Both leash members cannot be null");
        }
        HashMap<Object, ISilkLeashState> modifiedEntities = new HashMap<Object, ISilkLeashState>();
        if (leashOwner == null) {
            ISilkLeashState leashedLeashState = (ISilkLeashState)leashedEntity;
            if (leashedLeashState.getLeashedByEntities().isEmpty()) {
                return Map.of();
            }
            for (class_1297 class_12972 : leashedLeashState.getLeashedByEntities()) {
                if (!(class_12972 instanceof ISilkLeashState)) continue;
                ISilkLeashState state = (ISilkLeashState)class_12972;
                state.getLeashingEntities().remove(leashedEntity);
                modifiedEntities.put(class_12972, state);
            }
            leashedLeashState.getLeashedByEntities().clear();
            modifiedEntities.put(leashedEntity, leashedLeashState);
        } else {
            ISilkLeashState ownerLeashState = (ISilkLeashState)leashOwner;
            if (leashedEntity == null) {
                if (ownerLeashState.getLeashingEntities().isEmpty()) {
                    return Map.of();
                }
                for (class_1297 class_12973 : ownerLeashState.getLeashingEntities()) {
                    ISilkLeashState state = (ISilkLeashState)class_12973;
                    state.getLeashedByEntities().remove(leashOwner);
                    modifiedEntities.put(class_12973, state);
                }
                ownerLeashState.getLeashingEntities().clear();
            } else {
                if (!SilkLeashItem.canLeash((class_1297)leashOwner, (class_1297)leashedEntity)) {
                    return Map.of();
                }
                ISilkLeashState leashedEntityLeashState = (ISilkLeashState)leashedEntity;
                leashedEntityLeashState.getLeashedByEntities().add(leashOwner);
                ownerLeashState.getLeashingEntities().add(leashedEntity);
                modifiedEntities.put(leashedEntity, leashedEntityLeashState);
            }
            modifiedEntities.put(leashOwner, ownerLeashState);
        }
        return Map.copyOf(modifiedEntities);
    }

    private static boolean canLeash(class_1297 sourceEntity, class_1297 targetEntity) {
        if (!(sourceEntity instanceof ISilkLeashState)) {
            return false;
        }
        ISilkLeashState sourceLeashState = (ISilkLeashState)sourceEntity;
        if (sourceEntity == targetEntity) {
            return false;
        }
        return Stream.concat(sourceLeashState.getLeashingEntities().stream(), sourceLeashState.getLeashedByEntities().stream()).noneMatch(entity -> entity == targetEntity);
    }

    public class_1269 method_7847(class_1799 handStack, class_1657 player, class_1309 entity, class_1268 interactionHand) {
        ISilkLeashState playerLeashState = (ISilkLeashState)player;
        if (handStack.method_31574((class_1792)CACItems.SILK_LEAD.get()) && playerLeashState.getLeashingEntities().isEmpty()) {
            if (!player.method_31549().field_7477) {
                handStack.method_7934(1);
            }
            if (!player.method_37908().method_8608()) {
                SilkLeashItem.updateLeashStates((class_1309)player, entity);
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}

