/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.internal.common.cache.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mod.azure.azurelibarmor.common.internal.common.cache.texture.AutoGlowingTexture;
import mod.azure.azurelibarmor.common.platform.Services;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import net.minecraft.class_4668;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public abstract class AzAbstractTexture
extends class_1049 {
    protected static final class_4668.class_5942 SHADER_STATE = new class_4668.class_5942(class_757::method_42595);
    protected static final class_4668.class_4685 TRANSPARENCY_STATE = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final class_4668.class_4686 WRITE_MASK = new class_4668.class_4686(true, true);
    protected static final BiFunction<class_2960, Boolean, class_1921> GLOWING_RENDER_TYPE = class_156.method_34865((texture, isGlowing) -> {
        class_4668.class_4683 textureState = new class_4668.class_4683(texture, false, false);
        return class_1921.method_24049((String)"az_glowing_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(SHADER_STATE).method_34577((class_4668.class_5939)textureState).method_23615(TRANSPARENCY_STATE).method_23616(WRITE_MASK).method_23617(isGlowing.booleanValue()));
    });
    protected static final String APPENDIX = "_glowmask";

    public AzAbstractTexture(class_2960 location) {
        super(location);
    }

    public static void onRenderThread(class_4573 renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((class_4573)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected static void generateTexture(class_2960 texturePath, Consumer<class_1060> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (!(textureManager.method_34590(texturePath, (class_1044)class_1047.method_4540()) instanceof AzAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public static void uploadSimple(int texture, class_1011 image, boolean blur, boolean clamp) {
        TextureUtil.prepareImage((int)texture, (int)0, (int)image.method_4307(), (int)image.method_4323());
        image.method_22619(0, 0, 0, 0, 0, image.method_4307(), image.method_4323(), blur, clamp, false, true);
    }

    public static class_2960 appendToPath(class_2960 location, String suffix) {
        String path = location.method_12832();
        int i = path.lastIndexOf(46);
        return class_2960.method_60655((String)location.method_12836(), (String)(path.substring(0, i) + suffix + path.substring(i)));
    }

    public void method_4625(class_3300 resourceManager) throws IOException {
        class_4573 renderCall = this.loadTexture(resourceManager, class_310.method_1551());
        if (renderCall == null) {
            return;
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall((class_4573)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected void printDebugImageToDisk(class_2960 id, class_1011 newImage) {
        try {
            File file = new File(Services.PLATFORM.getGameDir().toFile(), "GeoTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, id.method_12832().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            newImage.method_4325(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    protected abstract class_4573 loadTexture(class_3300 var1, class_310 var2) throws IOException;

    protected static class_2960 getEmissiveResource(class_2960 baseResource) {
        class_2960 path = AzAbstractTexture.appendToPath(baseResource, APPENDIX);
        AzAbstractTexture.generateTexture(path, textureManager -> textureManager.method_4616(path, (class_1044)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    public static class_1921 getRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AzAbstractTexture.getEmissiveResource(texture), false);
    }

    public static class_1921 getOutlineRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AzAbstractTexture.getEmissiveResource(texture), true);
    }
}

