/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.internal.common.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import mod.azure.azurelibarmor.common.internal.common.loading.json.raw.Bone;
import mod.azure.azurelibarmor.common.internal.common.loading.json.raw.MinecraftGeometry;
import mod.azure.azurelibarmor.common.internal.common.loading.json.raw.Model;
import mod.azure.azurelibarmor.common.internal.common.loading.json.raw.ModelProperties;
import mod.azure.azurelibarmor.common.internal.common.loading.object.BoneStructure;

public record GeometryTree(Map<String, BoneStructure> topLevelBones, ModelProperties properties) {
    public static GeometryTree fromModel(Model model) {
        Object2ObjectOpenHashMap topLevelBones = new Object2ObjectOpenHashMap();
        MinecraftGeometry geometry = model.minecraftGeometry()[0];
        ObjectArrayList bones = new ObjectArrayList((Object[])geometry.bones());
        int index = bones.size() - 1;
        while (true) {
            Bone bone;
            if ((bone = (Bone)bones.get(index)).parent() == null) {
                topLevelBones.put(bone.name(), new BoneStructure(bone));
                bones.remove(index);
            } else {
                BoneStructure structure = GeometryTree.findBoneStructureInTree((Map<String, BoneStructure>)topLevelBones, bone.parent());
                if (structure != null) {
                    structure.children().put(bone.name(), new BoneStructure(bone));
                    bones.remove(index);
                }
            }
            if (index == 0) {
                index = bones.size() - 1;
                if (index != -1) continue;
                break;
            }
            --index;
        }
        return new GeometryTree((Map<String, BoneStructure>)topLevelBones, geometry.modelProperties());
    }

    private static BoneStructure findBoneStructureInTree(Map<String, BoneStructure> bones, String boneName) {
        for (BoneStructure entry : bones.values()) {
            if (boneName.equals(entry.self().name())) {
                return entry;
            }
            BoneStructure subStructure = GeometryTree.findBoneStructureInTree(entry.children(), boneName);
            if (subStructure == null) continue;
            return subStructure;
        }
        return null;
    }
}

