/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.core.animation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelibarmor.core.animation.Animation;

public final class RawAnimation {
    private final List<Stage> animationList = new ObjectArrayList();

    private RawAnimation() {
    }

    public static RawAnimation begin() {
        return new RawAnimation();
    }

    public static RawAnimation copyOf(RawAnimation other) {
        RawAnimation newInstance = RawAnimation.begin();
        newInstance.animationList.addAll(other.animationList);
        return newInstance;
    }

    public RawAnimation thenPlay(String animationName) {
        return this.then(animationName, Animation.LoopType.DEFAULT);
    }

    public RawAnimation thenLoop(String animationName) {
        return this.then(animationName, Animation.LoopType.LOOP);
    }

    public RawAnimation thenWait(int ticks) {
        this.animationList.add(new Stage("internal.wait", Animation.LoopType.PLAY_ONCE, ticks));
        return this;
    }

    public RawAnimation thenPlayAndHold(String animation) {
        return this.then(animation, Animation.LoopType.HOLD_ON_LAST_FRAME);
    }

    public RawAnimation thenPlayXTimes(String animationName, int playCount) {
        for (int i = 0; i < playCount; ++i) {
            this.then(animationName, i == playCount - 1 ? Animation.LoopType.DEFAULT : Animation.LoopType.PLAY_ONCE);
        }
        return this;
    }

    public RawAnimation then(String animationName, Animation.LoopType loopType) {
        this.animationList.add(new Stage(animationName, loopType));
        return this;
    }

    public List<Stage> getAnimationStages() {
        return this.animationList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.animationList);
    }

    public record Stage(String animationName, Animation.LoopType loopType, int additionalTicks) {
        static final String WAIT = "internal.wait";

        public Stage(String animationName, Animation.LoopType loopType) {
            this(animationName, loopType, 0);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.animationName, this.loopType);
        }
    }
}

