/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.dispatch.command;

import java.util.function.UnaryOperator;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.AzCommandBuilder;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootCancelAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootCancelAllAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootPlayAnimationSequenceAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootSetAnimationSpeedAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootSetEasingTypeAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootSetStartTickOffsetAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.action.impl.root.AzRootSetTransitionSpeedAction;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.sequence.AzAnimationSequence;
import mod.azure.azurelibarmor.rewrite.animation.dispatch.command.sequence.AzAnimationSequenceBuilder;
import mod.azure.azurelibarmor.rewrite.animation.easing.AzEasingType;

public class AzRootCommandBuilder
extends AzCommandBuilder {
    public AzRootCommandBuilder append(AzCommand command) {
        this.actions.addAll(command.actions());
        return this;
    }

    public AzRootCommandBuilder cancelAll() {
        this.actions.add(AzRootCancelAllAction.INSTANCE);
        return this;
    }

    public AzRootCommandBuilder setEasingType(AzEasingType easingType) {
        this.actions.add(new AzRootSetEasingTypeAction(easingType));
        return this;
    }

    public AzRootCommandBuilder setSpeed(float speed) {
        this.actions.add(new AzRootSetAnimationSpeedAction(speed));
        return this;
    }

    public AzRootCommandBuilder setTransitionSpeed(float transitionSpeed) {
        this.actions.add(new AzRootSetTransitionSpeedAction(transitionSpeed));
        return this;
    }

    public AzRootCommandBuilder setStartTickOffset(float tickOffset) {
        this.actions.add(new AzRootSetStartTickOffsetAction(tickOffset));
        return this;
    }

    public AzRootCommandBuilder cancel(String controllerName) {
        this.actions.add(new AzRootCancelAction(controllerName));
        return this;
    }

    public AzRootCommandBuilder play(String controllerName, String animationName) {
        return this.playSequence(controllerName, builder -> builder.queue(animationName, properties -> properties));
    }

    public AzRootCommandBuilder playSequence(String controllerName, UnaryOperator<AzAnimationSequenceBuilder> builderUnaryOperator) {
        AzAnimationSequence sequence = ((AzAnimationSequenceBuilder)builderUnaryOperator.apply(new AzAnimationSequenceBuilder())).build();
        this.actions.add(new AzRootPlayAnimationSequenceAction(controllerName, sequence));
        return this;
    }
}

