/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.property.codec;

import mod.azure.azurelibarmor.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelibarmor.rewrite.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelibarmor.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelibarmor.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelibarmor.rewrite.animation.play_behavior.AzPlayBehaviorRegistry;
import mod.azure.azurelibarmor.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelibarmor.rewrite.animation.property.AzAnimationStageProperties;
import net.minecraft.class_2540;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class AzAnimationStagePropertiesCodec
implements class_9139<class_2540, AzAnimationStageProperties> {
    @NotNull
    public AzAnimationStageProperties decode(class_2540 buf) {
        int propertyLength = buf.readByte();
        AzAnimationStageProperties properties = AzAnimationStageProperties.EMPTY;
        block7: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    Double animationSpeed = (Double)buf.method_43827(class_2540::readDouble);
                    properties = properties.withAnimationSpeed(animationSpeed != null ? animationSpeed : 1.0);
                    continue block7;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block7;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.method_19772(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                    continue block7;
                }
                case 3: {
                    AzPlayBehavior playBehavior = AzPlayBehaviorRegistry.getOrDefault(buf.method_19772(), AzPlayBehaviors.PLAY_ONCE);
                    properties = properties.withPlayBehavior(playBehavior);
                    continue block7;
                }
                case 4: {
                    Double startTickOffset = (Double)buf.method_43827(class_2540::readDouble);
                    properties = properties.withStartTickOffset(startTickOffset != null ? startTickOffset : 0.0);
                }
            }
        }
        return properties;
    }

    public void encode(class_2540 buf, AzAnimationStageProperties properties) {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        propertyLength += properties.hasEasingType() ? 1 : 0;
        propertyLength += properties.hasPlayBehavior() ? 1 : 0;
        buf.method_52997(propertyLength += properties.hasStartTickOffset() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.method_52997(0);
            buf.method_52940(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.method_52997(1);
            buf.method_52941(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.method_52997(2);
            buf.method_10814(properties.easingType().name());
        }
        if (properties.hasPlayBehavior()) {
            buf.method_52997(3);
            buf.method_10814(properties.playBehavior().name());
        }
        if (properties.hasStartTickOffset()) {
            buf.method_52997(4);
            buf.method_52940(properties.startTickOffset());
        }
    }
}

