/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelibarmor.core.animatable.model.CoreGeoBone;
import mod.azure.azurelibarmor.core.state.BoneSnapshot;
import mod.azure.azurelibarmor.rewrite.model.AzBoneMetadata;
import mod.azure.azurelibarmor.rewrite.model.AzBoneSnapshot;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AzBone
implements CoreGeoBone {
    private final AzBoneMetadata metadata;
    private final List<AzBone> children = new ObjectArrayList();
    private final List<GeoCube> cubes = new ObjectArrayList();
    private final Matrix4f modelSpaceMatrix = new Matrix4f();
    private final Matrix4f localSpaceMatrix = new Matrix4f();
    private final Matrix4f worldSpaceMatrix = new Matrix4f();
    private AzBoneSnapshot initialSnapshot;
    private boolean hidden;
    private boolean childrenHidden = false;
    private final Vector3f pivot;
    private final Vector3f position;
    private final Vector3f rotation;
    private final Vector3f scale;
    private boolean positionChanged = false;
    private boolean rotationChanged = false;
    private boolean scaleChanged = false;
    private Matrix3f worldSpaceNormal = new Matrix3f();
    private boolean trackingMatrices;

    public AzBone(AzBoneMetadata metadata) {
        this.metadata = metadata;
        this.trackingMatrices = false;
        this.hidden = metadata.dontRender() == Boolean.TRUE;
        this.position = new Vector3f();
        this.pivot = new Vector3f();
        this.rotation = new Vector3f();
        this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.worldSpaceNormal.identity();
        this.worldSpaceMatrix.identity();
        this.localSpaceMatrix.identity();
        this.modelSpaceMatrix.identity();
    }

    @Override
    public String getName() {
        return this.metadata.name();
    }

    @Override
    public AzBone getParent() {
        return this.metadata.parent();
    }

    @Override
    public float getRotX() {
        return this.rotation.x;
    }

    @Override
    public void setRotX(float value) {
        this.rotation.x = value;
        this.markRotationAsChanged();
    }

    @Override
    public float getRotY() {
        return this.rotation.y;
    }

    @Override
    public void setRotY(float value) {
        this.rotation.y = value;
        this.markRotationAsChanged();
    }

    @Override
    public float getRotZ() {
        return this.rotation.z;
    }

    @Override
    public void setRotZ(float value) {
        this.rotation.z = value;
        this.markRotationAsChanged();
    }

    @Override
    public float getPosX() {
        return this.position.x;
    }

    @Override
    public void setPosX(float value) {
        this.position.x = value;
        this.markPositionAsChanged();
    }

    @Override
    public float getPosY() {
        return this.position.y;
    }

    @Override
    public void setPosY(float value) {
        this.position.y = value;
        this.markPositionAsChanged();
    }

    @Override
    public float getPosZ() {
        return this.position.z;
    }

    @Override
    public void setPosZ(float value) {
        this.position.z = value;
        this.markPositionAsChanged();
    }

    @Override
    public float getScaleX() {
        return this.scale.x;
    }

    @Override
    public void setScaleX(float value) {
        this.scale.x = value;
        this.markScaleAsChanged();
    }

    @Override
    public float getScaleY() {
        return this.scale.y;
    }

    @Override
    public void setScaleY(float value) {
        this.scale.y = value;
        this.markScaleAsChanged();
    }

    @Override
    public float getScaleZ() {
        return this.scale.z;
    }

    @Override
    public void setScaleZ(float value) {
        this.scale.z = value;
        this.markScaleAsChanged();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setChildrenHidden(hidden);
    }

    @Override
    public void setChildrenHidden(boolean hideChildren) {
        this.childrenHidden = hideChildren;
    }

    @Override
    public float getPivotX() {
        return this.pivot.x;
    }

    @Override
    public void setPivotX(float value) {
        this.pivot.x = value;
    }

    @Override
    public float getPivotY() {
        return this.pivot.y;
    }

    @Override
    public void setPivotY(float value) {
        this.pivot.y = value;
    }

    @Override
    public float getPivotZ() {
        return this.pivot.z;
    }

    @Override
    public void setPivotZ(float value) {
        this.pivot.z = value;
    }

    @Override
    public boolean isHidingChildren() {
        return this.childrenHidden;
    }

    @Override
    public void markScaleAsChanged() {
        this.scaleChanged = true;
    }

    @Override
    public void markRotationAsChanged() {
        this.rotationChanged = true;
    }

    @Override
    public void markPositionAsChanged() {
        this.positionChanged = true;
    }

    @Override
    public boolean hasScaleChanged() {
        return this.scaleChanged;
    }

    @Override
    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    @Override
    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    @Override
    public void resetStateChanges() {
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.positionChanged = false;
    }

    @Override
    @Deprecated(forRemoval=true)
    public BoneSnapshot getInitialSnapshot() {
        throw new UnsupportedOperationException();
    }

    public AzBoneSnapshot getInitialAzSnapshot() {
        return this.initialSnapshot;
    }

    public List<AzBone> getChildBones() {
        return this.children;
    }

    @Override
    public void saveInitialSnapshot() {
        if (this.initialSnapshot == null) {
            this.initialSnapshot = new AzBoneSnapshot(this);
        }
    }

    public Boolean getMirror() {
        return this.metadata.mirror();
    }

    public Double getInflate() {
        return this.metadata.inflate();
    }

    public Boolean shouldNeverRender() {
        return this.metadata.dontRender();
    }

    public Boolean getReset() {
        return this.metadata.reset();
    }

    public List<GeoCube> getCubes() {
        return this.cubes;
    }

    public boolean isTrackingMatrices() {
        return this.trackingMatrices;
    }

    public void setTrackingMatrices(boolean trackingMatrices) {
        this.trackingMatrices = trackingMatrices;
    }

    public Matrix4f getModelSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.modelSpaceMatrix;
    }

    public void setModelSpaceMatrix(Matrix4f matrix) {
        this.modelSpaceMatrix.set((Matrix4fc)matrix);
    }

    public Matrix4f getLocalSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.localSpaceMatrix;
    }

    public void setLocalSpaceMatrix(Matrix4f matrix) {
        this.localSpaceMatrix.set((Matrix4fc)matrix);
    }

    public Matrix4f getWorldSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.worldSpaceMatrix;
    }

    public void setWorldSpaceMatrix(Matrix4f matrix) {
        this.worldSpaceMatrix.set((Matrix4fc)matrix);
    }

    public Matrix3f getWorldSpaceNormal() {
        return this.worldSpaceNormal;
    }

    public void setWorldSpaceNormal(Matrix3f matrix) {
        this.worldSpaceNormal = matrix;
    }

    public Vector3d getLocalPosition() {
        Vector4f vec = this.getLocalSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public Vector3d getModelPosition() {
        Vector4f vec = this.getModelSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)(-vec.x() * 16.0f), (double)(vec.y() * 16.0f), (double)(vec.z() * 16.0f));
    }

    public void setModelPosition(Vector3d pos) {
        AzBone parent = this.metadata.parent();
        Matrix4f matrix = (parent == null ? new Matrix4f().identity() : new Matrix4f((Matrix4fc)parent.getModelSpaceMatrix())).invert();
        Vector4f vec = matrix.transform(new Vector4f(-((float)pos.x) / 16.0f, (float)pos.y / 16.0f, (float)pos.z / 16.0f, 1.0f));
        this.updatePosition(-vec.x() * 16.0f, vec.y() * 16.0f, vec.z() * 16.0f);
    }

    public Vector3d getWorldPosition() {
        Vector4f vec = this.getWorldSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public Matrix4f getModelRotationMatrix() {
        Matrix4f matrix = new Matrix4f((Matrix4fc)this.getModelSpaceMatrix());
        matrix.m03(0.0f);
        matrix.m13(0.0f);
        matrix.m23(0.0f);
        return matrix;
    }

    public Vector3d getPositionVector() {
        return new Vector3d((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    public Vector3d getRotationVector() {
        return new Vector3d((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    public Vector3d getScaleVector() {
        return new Vector3d((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void addRotationOffsetFromBone(AzBone source) {
        this.setRotX(this.getRotX() + source.getRotX() - source.getInitialAzSnapshot().getRotX());
        this.setRotY(this.getRotY() + source.getRotY() - source.getInitialAzSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + source.getRotZ() - source.getInitialAzSnapshot().getRotZ());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getParent() != null ? this.getParent().getName() : Integer.valueOf(0), this.getCubes().size(), this.getChildBones().size());
    }
}

