/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.networking;

import com.b1n_ry.yigd.client.gui.GraveOverviewGui;
import com.b1n_ry.yigd.client.gui.GraveSelectionGui;
import com.b1n_ry.yigd.client.gui.PlayerSelectionGui;
import com.b1n_ry.yigd.client.gui.screens.GraveOverviewScreen;
import com.b1n_ry.yigd.client.gui.screens.GraveSelectionScreen;
import com.b1n_ry.yigd.client.gui.screens.PlayerSelectionScreen;
import com.b1n_ry.yigd.client.render.GraveBlockEntityRenderer;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.networking.LightGraveData;
import com.b1n_ry.yigd.networking.LightPlayerData;
import com.b1n_ry.yigd.networking.packets.DeleteGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.GraveOverviewRequestC2SPacket;
import com.b1n_ry.yigd.networking.packets.GraveOverviewS2CPacket;
import com.b1n_ry.yigd.networking.packets.GraveSelectionRequestC2SPacket;
import com.b1n_ry.yigd.networking.packets.GraveSelectionS2CPacket;
import com.b1n_ry.yigd.networking.packets.LockGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.PlayerSelectionS2CPacket;
import com.b1n_ry.yigd.networking.packets.RequestCompassC2SPacket;
import com.b1n_ry.yigd.networking.packets.RequestKeyC2SPacket;
import com.b1n_ry.yigd.networking.packets.RestoreGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.RobGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.SyncConfigS2CPacket;
import com.b1n_ry.yigd.networking.packets.UpdateConfigC2SPacket;
import io.github.cottonmc.cotton.gui.GuiDescription;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9296;

public class ClientPacketHandler {
    public static void registerReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(GraveOverviewS2CPacket.TYPE, (payload, context) -> {
            GraveComponent component = payload.component();
            boolean canRestore = payload.canRestore();
            boolean canRob = payload.canRob();
            boolean canDelete = payload.canDelete();
            boolean canUnlock = payload.canUnlock();
            boolean obtainableKeys = payload.obtainableKeys();
            boolean obtainableCompass = payload.obtainableCompass();
            class_310 client = context.client();
            client.execute(() -> client.method_1507((class_437)new GraveOverviewScreen((GuiDescription)new GraveOverviewGui(component, client.field_1755, canRestore, canRob, canDelete, canUnlock, obtainableKeys, obtainableCompass))));
        });
        ClientPlayNetworking.registerGlobalReceiver(GraveSelectionS2CPacket.TYPE, (payload, context) -> {
            List<LightGraveData> data = payload.data();
            class_9296 profile = payload.owner();
            class_310 client = context.client();
            client.execute(() -> client.method_1507((class_437)new GraveSelectionScreen((GuiDescription)new GraveSelectionGui(data, profile, client.field_1755))));
        });
        ClientPlayNetworking.registerGlobalReceiver(PlayerSelectionS2CPacket.TYPE, (payload, context) -> {
            List<LightPlayerData> data = payload.data();
            class_310 client = context.client();
            client.execute(() -> client.method_1507((class_437)new PlayerSelectionScreen((GuiDescription)new PlayerSelectionGui(data, client.field_1755))));
        });
        ClientPlayNetworking.registerGlobalReceiver(SyncConfigS2CPacket.TYPE, (payload, context) -> {
            YigdConfig.getConfig().graveConfig.retrieveMethods.onBreak = payload.gravesBreakable();
            GraveBlockEntityRenderer.syncedGlowing = payload.glowingGraves();
            GraveBlockEntityRenderer.syncedGlowingMaxDistance = payload.maxGraveGlowingDistance();
            GraveBlockEntityRenderer.syncedDeathSightDistance = payload.deathSightDistance();
        });
    }

    public static void sendRestoreGraveRequestPacket(UUID graveId, boolean itemsInGrave, boolean itemsDeleted, boolean itemsKept, boolean itemsDropped) {
        ClientPlayNetworking.send((class_8710)new RestoreGraveC2SPacket(graveId, itemsInGrave, itemsDeleted, itemsKept, itemsDropped));
    }

    public static void sendRobGraveRequestPacket(UUID graveId, boolean itemsInGrave, boolean itemsDeleted, boolean itemsKept, boolean itemsDropped) {
        ClientPlayNetworking.send((class_8710)new RobGraveC2SPacket(graveId, itemsInGrave, itemsDeleted, itemsKept, itemsDropped));
    }

    public static void sendDeleteGraveRequestPacket(UUID graveId) {
        ClientPlayNetworking.send((class_8710)new DeleteGraveC2SPacket(graveId));
    }

    public static void sendGraveLockRequestPacket(UUID graveId, boolean locked) {
        ClientPlayNetworking.send((class_8710)new LockGraveC2SPacket(graveId, locked));
    }

    public static void sendObtainKeysRequestPacket(UUID graveId) {
        ClientPlayNetworking.send((class_8710)new RequestKeyC2SPacket(graveId));
    }

    public static void sendObtainCompassRequestPacket(UUID graveId) {
        ClientPlayNetworking.send((class_8710)new RequestCompassC2SPacket(graveId));
    }

    public static void sendGraveOverviewRequest(UUID graveId) {
        ClientPlayNetworking.send((class_8710)new GraveOverviewRequestC2SPacket(graveId));
    }

    public static void sendGraveSelectionRequest(class_9296 profile) {
        ClientPlayNetworking.send((class_8710)new GraveSelectionRequestC2SPacket(profile));
    }

    public static void sendConfigUpdate(YigdConfig config) {
        ClientPlayNetworking.send((class_8710)new UpdateConfigC2SPacket(config.graveConfig.claimPriority, config.graveConfig.graveRobbing.robPriority));
    }
}

