/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.entity.EntityEasel;
import xerca.xercapaint.item.Items;

@Environment(value=EnvType.CLIENT)
public class GuiCanvasView
extends class_437 {
    private int canvasX;
    private int canvasY = 40;
    private final int canvasWidth;
    private final int canvasPixelScale;
    private final int canvasPixelWidth;
    private final int canvasPixelHeight;
    private final CanvasType canvasType;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private int generation = 0;
    private final EntityEasel easel;
    private final class_1657 player;

    protected GuiCanvasView(class_1799 canvasStack, class_2561 title, CanvasType canvasType, EntityEasel easel) {
        super(title);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.easel = easel;
        this.player = class_310.method_1551().field_1724;
        List stackPixels = (List)canvasStack.method_57824(Items.CANVAS_PIXELS);
        if (stackPixels != null) {
            this.authorName = (String)canvasStack.method_57824(Items.CANVAS_AUTHOR);
            this.canvasTitle = (String)canvasStack.method_57825(Items.CANVAS_TITLE, (Object)"");
            this.generation = (Integer)canvasStack.method_57825(Items.CANVAS_GENERATION, (Object)0);
            this.pixels = stackPixels.stream().mapToInt(i -> i).toArray();
        }
    }

    public void method_25426() {
        this.canvasX = (this.field_22789 - this.canvasWidth) / 2;
        if (this.canvasType.equals((Object)CanvasType.LONG)) {
            this.canvasY += 40;
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels == null ? -393218 : this.pixels[y * this.canvasPixelWidth + x];
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float f) {
        for (int i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int x = this.canvasX + j * this.canvasPixelScale;
                int y = this.canvasY + i * this.canvasPixelScale;
                guiGraphics.method_25294(x, y, x + this.canvasPixelScale, y + this.canvasPixelScale, this.getPixelAt(j, i));
            }
        }
        if (this.generation > 0 && !this.canvasTitle.isEmpty()) {
            String title = this.canvasTitle + " " + class_1074.method_4662((String)"canvas.byAuthor", (Object[])new Object[]{this.authorName});
            String gen = "(" + class_1074.method_4662((String)("canvas.generation." + (this.generation - 1)), (Object[])new Object[0]) + ")";
            int titleWidth = this.field_22793.method_1727(title);
            int genWidth = this.field_22793.method_1727(gen);
            float titleX = (float)this.canvasX + (float)(this.canvasWidth - titleWidth) / 2.0f;
            float genX = (float)this.canvasX + (float)(this.canvasWidth - genWidth) / 2.0f;
            float minX = Math.min(genX, titleX);
            float maxX = Math.max(genX + (float)genWidth, titleX + (float)titleWidth);
            guiGraphics.method_25294((int)(minX - 10.0f), this.canvasY - 30, (int)(maxX + 10.0f), this.canvasY - 4, -1118482);
            guiGraphics.method_51433(this.field_22793, title, (int)titleX, this.canvasY - 25, -15658735, false);
            guiGraphics.method_51433(this.field_22793, gen, (int)genX, this.canvasY - 14, -12303292, false);
        }
    }

    public void method_25393() {
        if (this.easel != null && (this.easel.getItem().method_7960() || this.easel.method_31481() || this.easel.method_5858((class_1297)this.player) > 64.0)) {
            this.method_25419();
        }
        super.method_25393();
    }
}

