/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.PaletteUtil;
import xerca.xercapaint.client.ModClient;
import xerca.xercapaint.item.Items;

public class ItemPalette
extends class_1792 {
    ItemPalette() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 worldIn, @NotNull class_1657 playerIn, @Nonnull class_1268 hand) {
        if (worldIn.field_9236) {
            ModClient.showCanvasGui(playerIn);
        }
        return new class_1271(class_1269.field_5812, (Object)playerIn.method_5998(hand));
    }

    public static boolean isFull(class_1799 stack) {
        return ItemPalette.basicColorCount(stack) == 16;
    }

    public static int basicColorCount(class_1799 stack) {
        if (stack.method_7909() != Items.ITEM_PALETTE) {
            return 0;
        }
        byte[] basicColors = (byte[])stack.method_57824(Items.PALETTE_BASIC_COLORS);
        if (basicColors != null && basicColors.length == 16) {
            int basicCount = 0;
            for (byte basicColor : basicColors) {
                basicCount += basicColor;
            }
            return basicCount;
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        byte[] basicColors = (byte[])stack.method_57824(Items.PALETTE_BASIC_COLORS);
        ComponentCustomColor customColorComp = (ComponentCustomColor)stack.method_57824(Items.PALETTE_CUSTOM_COLORS);
        if (basicColors == null && customColorComp == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"palette.empty").method_27692(class_124.field_1080));
        } else {
            if (basicColors != null && basicColors.length == 16) {
                int basicCount = 0;
                for (byte basicColor : basicColors) {
                    basicCount += basicColor;
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"palette.basic_count", (Object[])new Object[]{String.valueOf(basicCount)}).method_27692(class_124.field_1080));
            }
            if (customColorComp != null) {
                int fullCount = 0;
                for (PaletteUtil.CustomColor color : customColorComp.colors) {
                    if (color.numberOfColors <= 0) continue;
                    ++fullCount;
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"palette.custom_count", (Object[])new Object[]{String.valueOf(fullCount)}).method_27692(class_124.field_1080));
            }
        }
    }

    public static class ComponentCustomColor {
        public static final int CUSTOM_COLOR_COUNT = 12;
        public PaletteUtil.CustomColor[] colors;
        public static final PrimitiveCodec<ComponentCustomColor> CODEC = new PrimitiveCodec<ComponentCustomColor>(){

            public <T> DataResult<ComponentCustomColor> read(DynamicOps<T> ops, T input) {
                return ops.getIntStream(input).flatMap(intStream -> {
                    int[] allColorsArray = intStream.toArray();
                    if (allColorsArray.length != 60) {
                        return DataResult.error(() -> "Expected 60 integer values, but got: " + allColorsArray.length);
                    }
                    PaletteUtil.CustomColor[] customColors = new PaletteUtil.CustomColor[12];
                    for (int i = 0; i < 12; ++i) {
                        int baseIndex = i * 5;
                        int totalRed = allColorsArray[baseIndex];
                        int totalGreen = allColorsArray[baseIndex + 1];
                        int totalBlue = allColorsArray[baseIndex + 2];
                        int totalMaximum = allColorsArray[baseIndex + 3];
                        int numberOfColors = allColorsArray[baseIndex + 4];
                        customColors[i] = new PaletteUtil.CustomColor(totalRed, totalGreen, totalBlue, totalMaximum, numberOfColors);
                    }
                    return DataResult.success((Object)new ComponentCustomColor(customColors));
                });
            }

            public <T> T write(DynamicOps<T> ops, ComponentCustomColor value) {
                IntStream intStream = Arrays.stream(value.colors).flatMapToInt(cc -> Arrays.stream(new int[]{cc.totalRed, cc.totalGreen, cc.totalBlue, cc.totalMaximum, cc.numberOfColors}));
                return (T)ops.createIntList(intStream);
            }

            public String toString() {
                return "CustomColorCodec";
            }
        };

        public ComponentCustomColor(PaletteUtil.CustomColor[] customColors) {
            if (customColors.length != 12) {
                throw new IllegalArgumentException("customColors must have exactly 12 elements.");
            }
            this.colors = customColors;
        }
    }
}

