/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.config;

import com.cozary.nameless_trinkets.config.ConfigUtils;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItemData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public class TrinketConfigs {
    private static final Path rootPath = Path.of("config", "nameless_trinkets");
    private static Date launchStartDate;

    public static Path getRootPath() {
        return rootPath;
    }

    public static Date getLaunchStartDate() {
        return launchStartDate;
    }

    public static void setLaunchStartDate(Date date) {
        launchStartDate = date;
    }

    public static void loadClass() {
        TrinketConfigs.setLaunchStartDate(new Date());
        TrinketConfigs.createTrinketConfigs();
    }

    private static void createTrinketConfigs() {
        ModItems.CREATIVE_TAB_ITEMS.forEach(registryObject -> {
            class_1792 item = (class_1792)registryObject.get();
            if (item instanceof TrinketItem) {
                TrinketItem trinketItem = (TrinketItem)item;
                TrinketItemData<?> data = TrinketConfigs.readConfig(trinketItem);
                if (data == null || data.getConfig() == null) {
                    String itemName = TrinketConfigs.getItemName(trinketItem);
                    Path sourcePath = TrinketConfigs.getRootPath().resolve(itemName + ".json");
                    if (Files.exists(sourcePath, new LinkOption[0])) {
                        Path backupPath = TrinketConfigs.getBackupPath(sourcePath);
                        try {
                            Files.createDirectories(backupPath, new FileAttribute[0]);
                            Files.move(sourcePath, backupPath.resolve(itemName + ".json"), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            TrinketConfigs.logError(e, "Failed to backup config for " + itemName);
                        }
                    }
                    try {
                        TrinketConfigs.writeConfig(trinketItem);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to write config for " + itemName, e);
                    }
                    data = trinketItem.getTrinketData().toConfigData();
                }
                TrinketConfigs.syncTrinketData(trinketItem, data);
            }
        });
    }

    private static void writeConfig(TrinketItem<?> trinketItem) throws IOException {
        Path path = TrinketConfigs.getRootPath().resolve(TrinketConfigs.getItemName(trinketItem) + ".json");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        ConfigUtils.writeConfig(path, trinketItem.getTrinketData().toConfigData());
    }

    @Nullable
    private static TrinketItemData<?> readConfig(TrinketItem<?> trinketItem) {
        Path path = TrinketConfigs.getRootPath().resolve(TrinketConfigs.getItemName(trinketItem) + ".json");
        try {
            Object data = ConfigUtils.readConfig(path, TypeToken.getParameterized(TrinketItemData.class, (Type[])new Type[]{trinketItem.getTrinketData().getStatsClass()}).getType());
            if (data instanceof TrinketItemData) {
                return (TrinketItemData)data;
            }
        }
        catch (Exception e) {
            TrinketConfigs.logError(e, "Failed to read config for " + TrinketConfigs.getItemName(trinketItem));
        }
        return null;
    }

    private static void syncTrinketData(TrinketItem<?> trinketItem, TrinketItemData<?> data) {
        TrinketData trinketItemData = trinketItem.getTrinketData();
        trinketItemData.setStatsClass(data.getConfig().getClass());
        trinketItem.setTrinketData(trinketItemData);
        trinketItem.setTrinketConfig((TrinketsStats)data.getConfig());
    }

    public static String getItemName(TrinketItem<?> trinketItem) {
        return ModItems.CREATIVE_TAB_ITEMS.stream().filter(item -> item.get() == trinketItem).findFirst().map(item -> item.getId().method_12832()).orElseThrow(() -> new IllegalArgumentException("Trinket (Item) not found: " + String.valueOf(trinketItem)));
    }

    private static Path getBackupPath(Path sourcePath) {
        return TrinketConfigs.getRootPath().resolve("backups").resolve(new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(TrinketConfigs.getLaunchStartDate())).resolve(TrinketConfigs.getRootPath().relativize(sourcePath).getParent());
    }

    private static void logError(Exception e, String message) {
        System.err.println(message);
        e.printStackTrace();
    }
}

