/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5134;

public class GodsCrownBase
extends TrinketItem<Stats> {
    public static GodsCrownBase INSTANCE;
    protected final Map<String, List<String>> modifiers = new HashMap<String, List<String>>();

    public GodsCrownBase() {
        super(new TrinketData(null, null, Stats.class));
        INSTANCE = this;
        this.initModifiers();
    }

    protected void initModifiers() {
        ArrayList<String> modifierList = new ArrayList<String>();
        modifierList.add("gods_crown_max_health");
        modifierList.add("gods_crown_movement_speed");
        modifierList.add("gods_crown_flying_speed");
        modifierList.add("gods_crown_attack_damage");
        modifierList.add("gods_crown_armor");
        modifierList.add("gods_crown_attack_speed");
        modifierList.add("gods_crown_armor_thougness");
        modifierList.add("gods_crown_attack_knockback");
        modifierList.add("gods_crown_knockback_resistance");
        modifierList.add("gods_crown_luck");
        modifierList.add("gods_crown_block_reach");
        modifierList.add("gods_crown_entity_reach");
        modifierList.add("gods_crown_step_height_addition");
        modifierList.add("gods_crown_swim_speed");
        this.modifiers.put("nameless_trinkets", modifierList);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.nameless_trinkets.isDisabled").method_27692(class_124.field_1061));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.nameless_trinkets.gods_crown_lore").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}));
            if (class_437.method_25442()) {
                HashMap<String, Double> stats = new HashMap<String, Double>();
                stats.put("Max Health", config.percentageExtraMaxHealth);
                stats.put("Movement Speed", config.percentageExtraSpeed);
                stats.put("Flying Speed", config.percentageExtraFlySpeed);
                stats.put("Attack Damage", config.percentageExtraAttack);
                stats.put("Armor", config.percentageExtraArmor);
                stats.put("Attack Speed", config.percentageExtraAttackSpeed);
                stats.put("Armor Toughness", config.percentageExtraArmorToughness);
                stats.put("Attack Knockback", config.percentageExtraAttackKnockback);
                stats.put("Knockback Resistance", config.percentageExtraKnockbackResistance);
                stats.put("Luck", config.percentageExtraLuck);
                stats.put("Swim Speed", config.percentageExtraSwimSpeed);
                stats.put("Block Reach", config.percentageExtraBlockReach);
                stats.put("Entity Reach", config.percentageExtraEntityReach);
                stats.put("Step Height Addition", config.percentageExtraStepHeightAddition);
                for (Map.Entry entry : stats.entrySet()) {
                    if (!((Double)entry.getValue() > 0.0)) continue;
                    tooltip.add((class_2561)class_2561.method_43471((String)((String)entry.getKey())).method_27693(" +" + String.valueOf(entry.getValue()) + "%").method_27692(class_124.field_1065));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    protected void applyModifiers(class_1309 livingEntity, Stats config) {
        for (Map.Entry<String, List<String>> entry : this.modifiers.entrySet()) {
            for (String key : entry.getValue()) {
                class_1324 attribute = this.getAttribute(livingEntity, key);
                if (attribute == null) continue;
                class_2960 modifierData = class_2960.method_60655((String)entry.getKey(), (String)key);
                class_1322 modifier = this.createAttributeModifier(modifierData, config, key);
                EntityUtils.applyAttributeModifier(attribute, modifier);
            }
        }
    }

    protected class_1324 getAttribute(class_1309 entity, String key) {
        return switch (key) {
            case "gods_crown_max_health" -> entity.method_5996(class_5134.field_23716);
            case "gods_crown_movement_speed" -> entity.method_5996(class_5134.field_23719);
            case "gods_crown_flying_speed" -> entity.method_5996(class_5134.field_23720);
            case "gods_crown_attack_damage" -> entity.method_5996(class_5134.field_23721);
            case "gods_crown_armor" -> entity.method_5996(class_5134.field_23724);
            case "gods_crown_attack_speed" -> entity.method_5996(class_5134.field_23723);
            case "gods_crown_armor_thougness" -> entity.method_5996(class_5134.field_23725);
            case "gods_crown_attack_knockback" -> entity.method_5996(class_5134.field_23722);
            case "gods_crown_knockback_resistance" -> entity.method_5996(class_5134.field_23718);
            case "gods_crown_luck" -> entity.method_5996(class_5134.field_23726);
            case "gods_crown_swim_speed" -> entity.method_5996(class_5134.field_51578);
            case "gods_crown_block_reach" -> entity.method_5996(class_5134.field_47758);
            case "gods_crown_entity_reach" -> entity.method_5996(class_5134.field_47759);
            case "gods_crown_step_height_addition" -> entity.method_5996(class_5134.field_47761);
            default -> null;
        };
    }

    protected class_1322 createAttributeModifier(class_2960 modifierData, Stats config, String key) {
        double percentage = this.getPercentageForKey(config, key);
        return new class_1322(modifierData, percentage / 100.0, class_1322.class_1323.field_6331);
    }

    protected double getPercentageForKey(Stats config, String key) {
        return switch (key) {
            case "gods_crown_max_health" -> config.percentageExtraMaxHealth;
            case "gods_crown_movement_speed" -> config.percentageExtraSpeed;
            case "gods_crown_flying_speed" -> config.percentageExtraFlySpeed;
            case "gods_crown_attack_damage" -> config.percentageExtraAttack;
            case "gods_crown_armor" -> config.percentageExtraArmor;
            case "gods_crown_attack_speed" -> config.percentageExtraAttackSpeed;
            case "gods_crown_armor_thougness" -> config.percentageExtraArmorToughness;
            case "gods_crown_attack_knockback" -> config.percentageExtraAttackKnockback;
            case "gods_crown_knockback_resistance" -> config.percentageExtraKnockbackResistance;
            case "gods_crown_luck" -> config.percentageExtraLuck;
            case "gods_crown_swim_speed" -> config.percentageExtraSwimSpeed;
            case "gods_crown_block_reach" -> config.percentageExtraBlockReach;
            case "gods_crown_entity_reach" -> config.percentageExtraEntityReach;
            case "gods_crown_step_height_addition" -> config.percentageExtraStepHeightAddition;
            default -> 0.0;
        };
    }

    protected void removeModifiers(class_1309 wearer, Stats config) {
        for (Map.Entry<String, List<String>> entry : this.modifiers.entrySet()) {
            for (String key : entry.getValue()) {
                class_1324 attribute = this.getAttribute(wearer, key);
                if (attribute == null) continue;
                class_2960 modifierData = class_2960.method_60655((String)entry.getKey(), (String)key);
                class_1322 modifier = this.createAttributeModifier(modifierData, config, key);
                EntityUtils.removeAttributeModifier(attribute, modifier);
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public double percentageExtraMaxHealth = 50.0;
        public double percentageExtraSpeed = 25.0;
        public double percentageExtraFlySpeed = 15.0;
        public double percentageExtraAttack = 40.0;
        public double percentageExtraArmor = 30.0;
        public double percentageExtraAttackSpeed = 25.0;
        public double percentageExtraArmorToughness = 20.0;
        public double percentageExtraAttackKnockback = 15.0;
        public double percentageExtraKnockbackResistance = 30.0;
        public double percentageExtraLuck = 50.0;
        public double percentageExtraSwimSpeed = 25.0;
        public double percentageExtraBlockReach = 25.0;
        public double percentageExtraEntityReach = 25.0;
        public double percentageExtraStepHeightAddition = 0.0;
        public boolean isEnable = true;
    }
}

