/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import com.cozary.nameless_trinkets.init.ModTags;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9276;
import org.apache.commons.lang3.math.Fraction;

public class TrinketBundleContents
extends class_9276 {
    public static final TrinketBundleContents EMPTY = new TrinketBundleContents(List.of());
    public static final Codec<TrinketBundleContents> CODEC = class_1799.field_24671.listOf().xmap(TrinketBundleContents::new, trinketBundleContents -> trinketBundleContents.items);
    public static final class_9139<class_9129, TrinketBundleContents> STREAM_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(TrinketBundleContents::new, trinketBundleContents -> trinketBundleContents.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    public final List<class_1799> items;
    final Fraction weight;

    TrinketBundleContents(List<class_1799> itemStacks, Fraction fraction) {
        super(itemStacks);
        this.items = itemStacks;
        this.weight = fraction;
    }

    public TrinketBundleContents(List<class_1799> list) {
        this(list, TrinketBundleContents.computeContentWeight(list));
    }

    private static Fraction computeContentWeight(List<class_1799> p_336274_) {
        Fraction fraction = Fraction.ZERO;
        for (class_1799 itemstack : p_336274_) {
            fraction = fraction.add(TrinketBundleContents.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.method_7947(), (int)1)));
        }
        return fraction;
    }

    static Fraction getWeight(class_1799 itemStack) {
        return Fraction.getFraction((int)1, (int)64);
    }

    public class_1799 method_57422(int index) {
        return this.items.get(index);
    }

    public Stream<class_1799> method_59707() {
        return this.items.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> method_57421() {
        return this.items;
    }

    public List<class_1799> itemList() {
        return this.items;
    }

    public Iterable<class_1799> method_59708() {
        return Lists.transform(this.items, class_1799::method_7972);
    }

    public int method_57426() {
        return this.items.size();
    }

    public Fraction method_57428() {
        return this.weight;
    }

    public boolean method_57429() {
        return this.items.isEmpty();
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (this == other) {
            return true;
        }
        if (other instanceof TrinketBundleContents) {
            TrinketBundleContents TrinketBundleContents2 = (TrinketBundleContents)((Object)other);
            var10000 = this.weight.equals((Object)TrinketBundleContents2.weight) && class_1799.method_57362(this.items, TrinketBundleContents2.items);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        return class_1799.method_57361(this.items);
    }

    public String toString() {
        return "TrinketBundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        public final List<class_1799> items;
        private Fraction weight;

        public Mutable(TrinketBundleContents trinketBundleContents) {
            this.items = new ArrayList<class_1799>(trinketBundleContents.items);
            this.weight = trinketBundleContents.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(class_1799 itemStack) {
            if (!itemStack.method_7946()) {
                return -1;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (!class_1799.method_31577((class_1799)this.items.get(i), (class_1799)itemStack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(class_1799 itemStack) {
            return itemStack.method_31573(ModTags.NAMELESS_TRINKETS_TAG) ? (int)(64.0f - this.weight.floatValue() * 64.0f) : 0;
        }

        public int tryInsert(class_1799 itemStack) {
            if (!itemStack.method_7960() && itemStack.method_7909().method_31568()) {
                int i = Math.min(itemStack.method_7947(), this.getMaxAmountToAdd(itemStack));
                if (i == 0) {
                    return 0;
                }
                this.weight = this.weight.add(TrinketBundleContents.getWeight(itemStack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.findStackIndex(itemStack);
                if (j != -1) {
                    class_1799 itemstack = this.items.remove(j);
                    class_1799 itemstack1 = itemstack.method_46651(itemstack.method_7947() + i);
                    itemStack.method_7934(i);
                    this.items.add(0, itemstack1);
                } else {
                    this.items.add(0, itemStack.method_7971(i));
                }
                return i;
            }
            return 0;
        }

        public int tryTransfer(class_1735 slot, class_1657 player) {
            class_1799 itemstack = slot.method_7677();
            int i = this.getMaxAmountToAdd(itemstack);
            return this.tryInsert(slot.method_32753(itemstack.method_7947(), i, player));
        }

        public class_1799 removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            class_1799 itemstack = this.items.remove(0).method_7972();
            this.weight = this.weight.subtract(TrinketBundleContents.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.method_7947(), (int)1)));
            return itemstack;
        }

        public Fraction weight() {
            return this.weight;
        }

        public TrinketBundleContents toImmutable() {
            return new TrinketBundleContents(List.copyOf(this.items), this.weight);
        }
    }
}

