/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.entity.ia;

import com.google.common.collect.Lists;
import com.soytutta.mynethersdelight.common.block.MagmaCakeBlock;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MyCommonTags;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1589;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_7102;

public class EatMagmaCakeGoal
extends class_1352 {
    private static final int COOLDOWN_TICKS = 5;
    private static final int TONGUE_ANIMATION_DURATION = 10;
    private static final class_3414 TONGUE_SOUND = class_3417.field_37315;
    private final class_7102 frog;
    private final class_1937 level;
    private Object targetPos;
    private int eatAnimationTick;
    private int tongueAnimationTick;
    private int cooldownTick;

    public EatMagmaCakeGoal(class_7102 frog) {
        this.frog = frog;
        this.level = frog.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        this.updateTarget();
        return this.targetPos != null;
    }

    public void method_6269() {
        this.moveToTarget();
    }

    public void method_6270() {
        this.targetPos = null;
        this.eatAnimationTick = 0;
        this.tongueAnimationTick = 0;
        this.cooldownTick = 5;
        this.frog.method_18380(class_4050.field_18076);
    }

    public boolean method_6266() {
        return this.targetPos != null;
    }

    public void method_6268() {
        class_1297 entity;
        double distanceSq;
        if (this.cooldownTick > 0) {
            --this.cooldownTick;
            return;
        }
        this.updateTarget();
        this.moveToTarget();
        if (this.targetPos instanceof class_2338) {
            class_2338 pos = (class_2338)this.targetPos;
            double distanceSq2 = this.frog.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            if (distanceSq2 <= 3.0625) {
                this.handleBlockInteraction(pos);
            }
        } else if (this.targetPos instanceof class_1297 && (distanceSq = this.frog.method_5649((entity = (class_1297)this.targetPos).method_23317(), entity.method_23318(), entity.method_23321())) <= 3.0625) {
            this.handleEntityInteraction(entity);
        }
    }

    private void updateTarget() {
        List<class_2338> nearbyCakes = this.findNearbyCakes();
        double minDistanceSq = Double.MAX_VALUE;
        class_2338 closestTarget = null;
        class_2338 frogPos = this.frog.method_24515();
        for (class_2338 cakePos : nearbyCakes) {
            double distanceSq = frogPos.method_10262((class_2382)cakePos);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            closestTarget = cakePos;
        }
        class_1657 player = this.level.method_18460((class_1297)this.frog, 6.0);
        if (player != null && player.method_5858((class_1297)this.frog) <= 36.0) {
            double playerDistanceSq;
            class_1799 mainHand = player.method_6047();
            class_1799 offHand = player.method_6079();
            if ((mainHand.method_31573(MyCommonTags.FOODS_MAGMA_CUBE) || offHand.method_31573(MyCommonTags.FOODS_MAGMA_CUBE)) && (playerDistanceSq = frogPos.method_10262((class_2382)player.method_24515())) < minDistanceSq) {
                minDistanceSq = playerDistanceSq;
                closestTarget = player;
            }
        }
        this.targetPos = closestTarget;
    }

    private void moveToTarget() {
        if (this.targetPos instanceof class_2338) {
            class_2338 pos = (class_2338)this.targetPos;
            this.frog.method_5942().method_6337((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 1.5);
        } else if (this.targetPos instanceof class_1297) {
            class_1297 entity = (class_1297)this.targetPos;
            this.frog.method_5942().method_6337(entity.method_23317(), entity.method_23318(), entity.method_23321(), 1.5);
        }
    }

    private void handleBlockInteraction(class_2338 pos) {
        this.frog.method_5942().method_6340();
        this.frog.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        ++this.eatAnimationTick;
        if (this.eatAnimationTick == 1) {
            this.level.method_43129(null, (class_1297)this.frog, TONGUE_SOUND, class_3419.field_15254, 2.0f, 1.0f);
            this.frog.method_18380(class_4050.field_37423);
            this.frog.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            class_2680 state = this.level.method_8320(pos);
            if (state.method_26204() instanceof MagmaCakeBlock) {
                for (int i = 0; i < 3; ++i) {
                    class_1589 magmacube = (class_1589)class_1299.field_6102.method_5883(this.level);
                    if (magmacube == null) continue;
                    magmacube.method_7161(1, true);
                    magmacube.method_6033(1.0f);
                    magmacube.method_5648(true);
                    magmacube.method_5814(this.frog.method_23317(), this.frog.method_23318(), this.frog.method_23321());
                    this.level.method_8649((class_1297)magmacube);
                    this.frog.method_6121((class_1297)magmacube);
                    if (magmacube.method_5805()) continue;
                    magmacube.method_5650(class_1297.class_5529.field_26998);
                }
                this.frog.method_6092(new class_1293(class_1294.field_5918, 200, 0));
                int bites = (Integer)state.method_11654((class_2769)MagmaCakeBlock.BITES);
                if (bites < 6) {
                    this.level.method_8501(pos, (class_2680)state.method_11657((class_2769)MagmaCakeBlock.BITES, (Comparable)Integer.valueOf(bites + 1)));
                } else if (((Boolean)state.method_11654((class_2769)MagmaCakeBlock.SECOND_CAKE)).booleanValue()) {
                    this.level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)MagmaCakeBlock.BITES, (Comparable)Integer.valueOf(0))).method_11657((class_2769)MagmaCakeBlock.SECOND_CAKE, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.level.method_22352(pos, false);
                }
                this.cooldownTick = 5;
            }
        }
        if (this.tongueAnimationTick < 10) {
            this.frog.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            ++this.tongueAnimationTick;
        } else {
            this.method_6270();
        }
    }

    private void handleEntityInteraction(class_1297 entity) {
        this.frog.method_5942().method_6340();
        this.frog.method_5988().method_20248(entity.method_23317(), entity.method_23318(), entity.method_23321());
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1799 mainHand = player.method_6047();
            class_1799 offHand = player.method_6079();
            if (mainHand.method_7909() == MNDItems.MAGMA_CAKE_SLICE.get() || offHand.method_7909() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                ++this.eatAnimationTick;
                if (this.eatAnimationTick == 1) {
                    this.level.method_43129(null, (class_1297)this.frog, TONGUE_SOUND, class_3419.field_15254, 2.0f, 1.0f);
                    this.frog.method_18380(class_4050.field_37423);
                    this.frog.method_5988().method_20248(entity.method_23317(), entity.method_23318(), entity.method_23321());
                    if (mainHand.method_7909() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                        mainHand.method_7934(1);
                    } else if (offHand.method_7909() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                        offHand.method_7934(1);
                    }
                    for (int i = 0; i < 3; ++i) {
                        class_1589 magmacube = (class_1589)class_1299.field_6102.method_5883(this.level);
                        if (magmacube == null) continue;
                        magmacube.method_7161(1, true);
                        magmacube.method_6033(1.0f);
                        magmacube.method_5648(true);
                        magmacube.method_5814(this.frog.method_23317(), this.frog.method_23318(), this.frog.method_23321());
                        this.level.method_8649((class_1297)magmacube);
                        this.frog.method_6121((class_1297)magmacube);
                        if (magmacube.method_5805()) continue;
                        magmacube.method_5650(class_1297.class_5529.field_26998);
                    }
                    this.frog.method_6092(new class_1293(class_1294.field_5918, 200, 0));
                }
            }
        }
        if (this.tongueAnimationTick < 10) {
            this.frog.method_5988().method_20248(entity.method_23317(), entity.method_23318(), entity.method_23321());
            ++this.tongueAnimationTick;
        } else {
            this.method_6270();
        }
    }

    private List<class_2338> findNearbyCakes() {
        ArrayList cakePositions = Lists.newArrayList();
        class_2338 frogPos = this.frog.method_24515();
        int searchRadius = 10;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    class_2338 pos = frogPos.method_10069(x, y, z);
                    if (!(this.level.method_8320(pos).method_26204() instanceof MagmaCakeBlock)) continue;
                    cakePositions.add(pos);
                }
            }
        }
        return cakePositions;
    }
}

