/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_9331;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.MoltenParticleComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class MoltenEdgeSwordItem
extends UniqueSwordItem {
    public MoltenEdgeSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker.method_37908().method_8608()) {
            return super.method_7873(stack, target, attacker);
        }
        int proc_chance = Config.uniqueEffects.molten_edge.chance;
        class_3218 world = (class_3218)attacker.method_37908();
        HelperMethods.playHitSounds(attacker, target);
        if (attacker.method_59922().method_43048(100) <= proc_chance) {
            world.method_43129(null, (class_1297)attacker, (class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), attacker.method_5634(), 0.6f, 2.0f);
            if (attacker.method_59922().method_43048(100) <= 50) {
                if (attacker.method_6032() > 2.0f) {
                    attacker.method_5639(3.0f);
                }
                if (attacker.method_6032() < 4.0f) {
                    attacker.method_37222(new class_1293(class_1294.field_5924, 60, 3), (class_1297)attacker);
                }
            } else if (attacker.method_59922().method_43048(100) > 50) {
                target.method_5639(3.0f);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_37908().method_8608()) {
            return super.method_7836(world, user, hand);
        }
        double radius = Config.uniqueEffects.molten_edge.radius;
        double knockbackStrength = Config.uniqueEffects.molten_edge.knockbackStrength;
        int abilityCooldown = Config.uniqueEffects.molten_edge.cooldown;
        int amp = 0;
        class_238 box = new class_238(user.method_23317() + radius, user.method_23318() + radius, user.method_23321() + radius, user.method_23317() - radius, user.method_23318() - radius, user.method_23321() - radius);
        for (class_1297 entity : world.method_8333((class_1297)user, box, class_1301.field_6157)) {
            class_1309 le;
            if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, (class_1309)user)) continue;
            ++amp;
            le.method_18800((le.method_23317() - user.method_23317()) / knockbackStrength, 0.6, (le.method_23321() - user.method_23321()) / knockbackStrength);
            le.method_5639(3.0f);
        }
        world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.method_5634(), 0.7f, 1.5f);
        int duration = Config.uniqueEffects.molten_edge.duration * amp / 2;
        user.method_37222(new class_1293(EffectRegistry.getReference(EffectRegistry.ONSLAUGHT), duration, 0), (class_1297)user);
        user.method_37222(new class_1293(class_1294.field_5907, duration, 3), (class_1297)user);
        user.method_7357().method_7906((class_1792)this, abilityCooldown);
        class_1799 stack = user.method_5998(hand);
        stack.method_57379((class_9331)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((class_2394)class_2398.field_11239, (class_2394)class_2398.field_11239, (class_2394)class_2398.field_11237));
        return super.method_7836(world, user, hand);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (!world.field_9236 && entity instanceof class_1657 && (player = (class_1657)entity).method_6118(class_1304.field_6173) == stack) {
            int amp = 0;
            if (player.field_6012 % 40 == 0) {
                if (player.method_6032() < player.method_6063() / 2.0f && player.method_6032() > player.method_6063() / 3.0f) {
                    amp = 1;
                    stack.method_57379((class_9331)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((class_2394)class_2398.field_18304, (class_2394)class_2398.field_18304, (class_2394)class_2398.field_11237));
                } else if (player.method_6032() < player.method_6063() / 3.0f && player.method_6032() > 2.0f) {
                    amp = 2;
                    stack.method_57379((class_9331)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((class_2394)class_2398.field_18304, (class_2394)class_2398.field_18304, (class_2394)class_2398.field_11237));
                } else if (player.method_6032() <= 2.0f) {
                    amp = 3;
                    stack.method_57379((class_9331)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)new MoltenParticleComponent((class_2394)class_2398.field_11239, (class_2394)class_2398.field_11239, (class_2394)class_2398.field_11237));
                } else {
                    stack.method_57379((class_9331)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)MoltenParticleComponent.DEFAULT);
                }
                player.method_37222(new class_1293(class_1294.field_5910, 40, amp), (class_1297)player);
                player.method_37222(new class_1293(class_1294.field_5904, 40, amp - 1), (class_1297)player);
            }
        }
        MoltenParticleComponent component = (MoltenParticleComponent)stack.method_57825((class_9331)ComponentTypeRegistry.MOLTEN_PARTICLE.get(), (Object)MoltenParticleComponent.DEFAULT);
        HelperMethods.createFootfalls(entity, stack, world, component.walk(), component.sprint(), component.passive(), true);
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip1").method_10862(Styles.ABILITY));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip2").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip3").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip4").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(Styles.RIGHT_CLICK));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip5").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip6").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.moltenedgesworditem.tooltip7").method_10862(Styles.TEXT));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedFloat.Restrict(min=0.0f)
        public double knockbackStrength;
        @ValidatedDouble.Restrict(min=1.0)
        public double radius;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.MOLTEN_EDGE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 15;
            this.cooldown = 320;
            this.duration = 100;
            this.knockbackStrength = 5.0;
            this.radius = 5.0;
        }
    }
}

