/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class SoundHelper {
    private static final Map<class_2960, ScheduledExecutorService> soundSchedulers = new ConcurrentHashMap<class_2960, ScheduledExecutorService>();

    public static void loopSound(class_1309 entity, class_2960 soundId, int soundDurationSeconds, int updateFrequencyTicks) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)entity.method_37908();
        class_3414 soundEvent = (class_3414)SoundRegistry.SOUND.getRegistrar().get(soundId);
        if (soundSchedulers.containsKey(soundId)) {
            return;
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        soundSchedulers.put(soundId, scheduler);
        int totalTicks = soundDurationSeconds * 20;
        int[] elapsedTicks = new int[]{0};
        scheduler.scheduleAtFixedRate(() -> {
            elapsedTicks[0] = elapsedTicks[0] + updateFrequencyTicks;
            if (entity.method_5805() && elapsedTicks[0] < totalTicks && entity.method_6059(EffectRegistry.getReference(EffectRegistry.ELEMENTAL_VORTEX))) {
                float playbackProgress = (float)(elapsedTicks[0] % totalTicks) / (float)totalTicks;
                float pitch = 1.0f + playbackProgress * 0.2f;
                serverWorld.method_8396(null, entity.method_24515(), soundEvent, entity.method_5634(), 1.0f, pitch);
            } else {
                SoundHelper.stopLoopingSound(entity, soundId);
            }
        }, 0L, (long)updateFrequencyTicks * 50L, TimeUnit.MILLISECONDS);
    }

    public static void stopLoopingSound(class_1309 entity, class_2960 soundId) {
        ScheduledExecutorService scheduler = soundSchedulers.remove(soundId);
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
    }
}

