/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.VariableHelper;

public interface IVariable {
    public <T> T as(Class<T> var1);

    default public <T> T as(Class<T> clazz, T def) {
        return this.unwrap().isJsonNull() ? def : this.as(clazz);
    }

    public JsonElement unwrap();

    default public String asString() {
        return this.asString("");
    }

    default public String asString(String def) {
        return this.unwrap().isJsonNull() ? def : this.unwrap().getAsString();
    }

    default public Number asNumber() {
        return this.asNumber(0);
    }

    default public Number asNumber(Number def) {
        return this.unwrap().isJsonNull() ? (Number)def : (Number)this.unwrap().getAsNumber();
    }

    default public boolean asBoolean() {
        return this.asBoolean(false);
    }

    default public boolean asBoolean(boolean def) {
        return this.unwrap().isJsonNull() ? def : !this.unwrap().getAsString().equals("false") && !this.unwrap().getAsString().isEmpty() && this.unwrap().getAsBoolean();
    }

    default public Stream<IVariable> asStream(class_7225.class_7874 registries) {
        return StreamSupport.stream(this.unwrap().getAsJsonArray().spliterator(), false).map(json -> IVariable.wrap(json, registries));
    }

    default public Stream<IVariable> asStreamOrSingleton(class_7225.class_7874 registries) {
        return this.unwrap().isJsonArray() ? this.asStream(registries) : Stream.of(this);
    }

    default public List<IVariable> asList(class_7225.class_7874 registries) {
        return this.asStream(registries).collect(Collectors.toList());
    }

    default public List<IVariable> asListOrSingleton(class_7225.class_7874 registries) {
        return this.asStreamOrSingleton(registries).collect(Collectors.toList());
    }

    public static <T> IVariable from(@Nullable T object, class_7225.class_7874 registries) {
        return object != null ? VariableHelper.instance().createFromObject(object, registries) : IVariable.empty();
    }

    public static IVariable wrap(@Nullable JsonElement elem, class_7225.class_7874 registries) {
        return elem != null ? VariableHelper.instance().createFromJson(elem, registries) : IVariable.empty();
    }

    public static IVariable wrapList(Iterable<IVariable> elems, class_7225.class_7874 registries) {
        JsonArray arr = new JsonArray();
        for (IVariable v : elems) {
            arr.add(v.unwrap());
        }
        return IVariable.wrap((JsonElement)arr, registries);
    }

    @Deprecated
    public static IVariable wrap(@Nullable Number n) {
        return IVariable.wrap(n, (class_7225.class_7874)class_5455.field_40585);
    }

    public static IVariable wrap(@Nullable Number n, class_7225.class_7874 registries) {
        return n != null ? IVariable.wrap((JsonElement)new JsonPrimitive(n), registries) : IVariable.empty();
    }

    @Deprecated
    public static IVariable wrap(@Nullable Boolean b) {
        return IVariable.wrap(b, (class_7225.class_7874)class_5455.field_40585);
    }

    public static IVariable wrap(@Nullable Boolean b, class_7225.class_7874 registries) {
        return b != null ? IVariable.wrap((JsonElement)new JsonPrimitive(b), registries) : IVariable.empty();
    }

    @Deprecated
    public static IVariable wrap(@Nullable String s) {
        return IVariable.wrap(s, (class_7225.class_7874)class_5455.field_40585);
    }

    public static IVariable wrap(@Nullable String s, class_7225.class_7874 registries) {
        return s != null ? IVariable.wrap((JsonElement)new JsonPrimitive(s), registries) : IVariable.empty();
    }

    public static IVariable empty() {
        return IVariable.wrap((JsonElement)JsonNull.INSTANCE, (class_7225.class_7874)class_5455.field_40585);
    }

    public static class Serializer
    implements JsonDeserializer<IVariable> {
        private class_7225.class_7874 registryCache;

        public IVariable deserialize(JsonElement elem, Type t, JsonDeserializationContext c) {
            if (this.registryCache == null || this.registryCache.method_55282().findFirst().isEmpty()) {
                this.registryCache = class_5455.method_40302((class_2378)class_7923.field_41167);
            }
            return IVariable.wrap(elem, this.registryCache);
        }

        public void setRegistries(class_7225.class_7874 registries) {
            this.registryCache = registries;
        }
    }
}

