/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import vazkii.patchouli.api.PatchouliConfigAccess;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer
implements class_4068 {
    private final Book book;
    private final BookTextParser parser;
    private final TextLayouter layouter;
    private List<Word> words;
    private float scale;

    public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, class_2561 text, int x, int y, int width, int lineHeight, int baseColor) {
        this.book = gui.book;
        class_2583 baseStyle = this.book.getFontStyle().method_27703(class_5251.method_27717((int)baseColor));
        this.parser = new BookTextParser(gui, this.book, x, y, width, lineHeight, baseStyle);
        PatchouliConfigAccess.TextOverflowMode overflowMode = this.book.overflowMode;
        if (overflowMode == null) {
            overflowMode = PatchouliConfig.get().overflowMode();
        }
        this.layouter = new TextLayouter(gui, x, y, lineHeight, width, overflowMode);
        this.setText(text);
    }

    void setText(class_2561 text) {
        class_2561 text1;
        class_7417 class_74172;
        if (this.book.i18n && (class_74172 = text.method_10851()) instanceof class_8828.class_2585) {
            class_8828.class_2585 lc = (class_8828.class_2585)class_74172;
            text1 = class_2561.method_43470((String)class_1074.method_4662((String)lc.comp_737(), (Object[])new Object[0]));
        } else {
            text1 = text;
        }
        this.layouter.layout(class_310.method_1551().field_1772, this.parser.parse(text1));
        this.scale = this.layouter.getScale();
        this.words = this.layouter.getWords();
    }

    private double rescale(double in, double origin) {
        return origin + (in - origin) / (double)this.scale;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.words.isEmpty()) {
            class_327 font = class_310.method_1551().field_1772;
            class_2583 style = this.book.getFontStyle();
            Word first = this.words.get(0);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)first.x, (float)first.y, 0.0f);
            graphics.method_51448().method_22905(this.scale, this.scale, 1.0f);
            graphics.method_51448().method_46416((float)(-first.x), (float)(-first.y), 0.0f);
            int scaledX = (int)this.rescale(mouseX, first.x);
            int scaledY = (int)this.rescale(mouseY, first.y);
            this.words.forEach(word -> word.render(graphics, font, style, scaledX, scaledY));
            graphics.method_51448().method_22909();
        }
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (!this.words.isEmpty()) {
            Word first = this.words.get(0);
            double scaledX = this.rescale(mouseX, first.x);
            double scaledY = this.rescale(mouseY, first.y);
            for (Word word : this.words) {
                if (!word.click(scaledX, scaledY, mouseButton)) continue;
                return true;
            }
        }
        return false;
    }
}

