/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2291;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;

public final class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static Triple<class_6880<class_1792>, class_9326, Integer> deserializeStack(String string, class_7225.class_7874 registries) {
        StringReader reader = new StringReader(string.trim());
        class_2291 itemParser = new class_2291(registries);
        try {
            class_2291.class_7215 result = itemParser.method_9789(reader);
            int count = 1;
            if (reader.canRead()) {
                reader.expect('#');
                count = reader.readInt();
            }
            return Triple.of((Object)result.comp_628(), (Object)result.comp_2439(), (Object)count);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_1799 loadFromParsed(Triple<class_6880<class_1792>, class_9326, Integer> parsed) {
        class_6880 holder = (class_6880)parsed.getLeft();
        class_9326 components = (class_9326)parsed.getMiddle();
        Integer count = (Integer)parsed.getRight();
        if (!holder.method_40227() && holder.method_40230().isPresent()) {
            throw new RuntimeException("Unknown item ID: " + String.valueOf(((class_5321)holder.method_40230().get()).method_29177()));
        }
        class_1792 item = (class_1792)holder.comp_349();
        class_1799 stack = new class_1799((class_1935)item, count.intValue());
        if (!components.method_57848()) {
            stack.method_57366(components);
        }
        return stack;
    }

    public static class_1799 loadStackFromString(String res, class_7225.class_7874 registries) {
        return ItemStackUtil.loadFromParsed(ItemStackUtil.deserializeStack(res, registries));
    }

    public static class_1856 loadIngredientFromString(String ingredientString, class_7225.class_7874 registries) {
        return class_1856.method_8101((class_1799[])ItemStackUtil.loadStackListFromString(ingredientString, registries).toArray(new class_1799[0]));
    }

    public static List<class_1799> loadStackListFromString(String ingredientString, class_7225.class_7874 registries) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (String s : stacksSerialized) {
            if (s.isEmpty()) continue;
            if (s.startsWith("tag:")) {
                class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)s.substring(4)));
                registries.method_46762(class_7924.field_41197).method_46733(key).stream().flatMap(class_6885::method_40239).forEach(item -> stacks.add(new class_1799(item)));
                continue;
            }
            stacks.add(ItemStackUtil.loadStackFromString(s, registries));
        }
        return stacks;
    }

    public static StackWrapper wrapStack(class_1799 stack) {
        return stack.method_7960() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    @Nullable
    public static Book getBookFromStack(class_1799 stack) {
        if (stack.method_7909() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!class_1799.method_7984((class_1799)b.getBookItem(), (class_1799)stack)) continue;
            return b;
        }
        return null;
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        int brackets = 0;
        Character insideString = null;
        block9: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block9;
                    ++braces;
                    continue block9;
                }
                case '}': {
                    if (insideString != null) continue block9;
                    --braces;
                    continue block9;
                }
                case '[': {
                    if (insideString != null) continue block9;
                    ++brackets;
                    continue block9;
                }
                case ']': {
                    if (insideString != null) continue block9;
                    --brackets;
                    continue block9;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block9;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block9;
                }
                case ',': {
                    if (braces > 0 || brackets > 0) continue block9;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[0]);
    }

    public static class_1799 loadStackFromJson(JsonObject json, class_7225.class_7874 registries) {
        String itemName = json.get("item").getAsString();
        class_1792 item = (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)itemName)).orElseThrow(() -> new IllegalArgumentException("Unknown item '" + itemName + "'"));
        class_1799 stack = new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
        if (json.has("components")) {
            class_9323.field_50234.parse((DynamicOps)registries.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)json.get("components")).result().ifPresent(arg_0 -> ((class_1799)stack).method_57365(arg_0));
        }
        return stack;
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(class_1799.field_8037);
        public final class_1799 stack;

        public StackWrapper(class_1799 stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && class_1799.method_7984((class_1799)this.stack, (class_1799)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.method_7909().hashCode();
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

