/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ReplaceableJsonResourceReloadListener
extends class_4080<Map<class_2960, JsonObject>> {
    private final Logger logger;
    private final Gson gson;
    protected final String directory;

    protected ReplaceableJsonResourceReloadListener(Gson gson, Logger logger, String directory) {
        this.logger = logger;
        this.gson = gson;
        this.directory = directory;
    }

    protected Map<class_2960, JsonObject> prepare(class_3300 resourceManager, class_3695 profiler) {
        class_7654 fileToIdConverter = class_7654.method_45114((String)this.directory);
        LinkedHashMap<class_2960, JsonObject> output = new LinkedHashMap<class_2960, JsonObject>();
        for (Map.Entry entry : fileToIdConverter.method_45116(resourceManager).entrySet()) {
            class_2960 filePath = (class_2960)entry.getKey();
            class_2960 resourceLocation = fileToIdConverter.method_45115((class_2960)entry.getKey());
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                        if (!(jsonElement instanceof JsonObject)) {
                            this.logger.warn("File was found not to be parsed as a valid JsonObject, it will be skipped: [Location: " + String.valueOf(filePath) + "]");
                            continue;
                        }
                        JsonObject jsonObject = (JsonObject)jsonElement;
                        if (output.containsKey(resourceLocation)) {
                            JsonObject jsonObject2 = output.get(resourceLocation).getAsJsonObject();
                            if (!class_3518.method_15270((JsonObject)jsonObject, (String)"replace")) continue;
                            jsonObject.asMap().forEach((arg_0, arg_1) -> ((JsonObject)jsonObject2).add(arg_0, arg_1));
                            continue;
                        }
                        output.put(resourceLocation, jsonObject);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException var14) {
                    this.logger.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation, resourceLocation, var14});
                }
            }
        }
        return output;
    }

    public <T> void decodeJsonArray(JsonArray jsonArray, String name, class_2960 location, Function<JsonElement, @Nullable T> decoder, Consumer<T> consumer) {
        for (JsonElement element : jsonArray) {
            if (!element.isJsonPrimitive()) {
                this.logger.warn("Unable to parse " + name + " as it is not a valid Json Primitive! [Location: " + String.valueOf(location) + "]");
                continue;
            }
            T value = decoder.apply(element);
            if (value == null) {
                this.logger.warn("Unable to parse " + name + " as it is not a valid ResourceLocation! [Location: " + String.valueOf(location) + ", Value: " + element.getAsString() + "]");
                continue;
            }
            consumer.accept(value);
        }
    }

    @Nullable
    protected <T> T safeHelper(BiFunction<JsonObject, String, T> func, JsonObject object, String key, class_2960 location) {
        return this.safeHelper(func, object, key, null, location);
    }

    protected <T> T safeHelper(BiFunction<JsonObject, String, T> func, JsonObject object, String key, T defaultValue, class_2960 location) {
        if (!object.has(key)) {
            return defaultValue;
        }
        try {
            return func.apply(object, key);
        }
        catch (Exception e) {
            this.logger.warn("Unable to deserialize value for the given file: [Location: " + String.valueOf(location) + ", Field: " + key + "]", (Throwable)e);
            return defaultValue;
        }
    }
}

