/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.slf4j.Logger;

public record InvalidateEntityCache(int entityId) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final StructEndec<InvalidateEntityCache> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", InvalidateEntityCache::entityId), InvalidateEntityCache::new);

    @Environment(value=EnvType.CLIENT)
    public static void handlePacket(InvalidateEntityCache packet, class_1657 player) {
        class_1937 level = player.method_37908();
        class_1297 entity = level.method_8469(packet.entityId());
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        AccessoriesHolderLookupCache cache = ((AccessoriesHolderImpl)capability.getHolder()).getLookupCache();
        if (cache != null) {
            cache.clearCache();
        }
    }
}

