/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPacks;
import de.cristelknight.cristellib.config.ConfigType;
import de.cristelknight.cristellib.config.ConfigUtil;
import de.cristelknight.cristellib.data.Conditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.commons.io.FileUtils;

public class ReadData {
    private static boolean checkedConfigFiles = false;

    public static void getBuiltInPacks(String modId) {
        for (Path path : ReadData.getPathsInDir(modId, "data_packs")) {
            InputStream stream;
            try {
                stream = Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
            if (!(element instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)element;
            if (object.has("packs")) {
                JsonArray array = object.getAsJsonArray("packs");
                for (int i = array.size() - 1; i >= 0; --i) {
                    JsonElement jsonElement = array.get(i);
                    ReadData.loadPack(jsonElement, modId);
                }
                continue;
            }
            ReadData.loadPack((JsonElement)object, modId);
        }
        checkedConfigFiles = false;
    }

    public static void copyFile(String modId) {
        for (Path path : ReadData.getPathsInDir(modId, "copy_file")) {
            InputStream stream;
            try {
                stream = Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
            if (!(element instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)element;
            String location = object.get("location").getAsString();
            String destination = object.get("destination").getAsString();
            if (!Conditions.readConditions(object)) continue;
            ReadData.copyFileFromJar(location, destination, modId);
        }
        checkedConfigFiles = false;
    }

    public static void loadPack(JsonElement element, String modId) {
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            String location = object.get("location").getAsString();
            String name = object.get("display_name").getAsString();
            class_2960 rl = class_2960.method_12829((String)location);
            class_5250 component = class_2561.method_43470((String)name);
            boolean b = Conditions.readConditions(object);
            BuiltInDataPacks.registerPack(rl, modId, (class_2561)component, () -> b);
        }
    }

    public static void copyFileFromJar(String from, String to, String frommodId) {
        List<Path> inputUrl = CristelLibExpectPlatform.getRootPaths(frommodId);
        for (Path p : inputUrl) {
            Path fromFile = p.resolve(from);
            File toFile = ConfigUtil.CONFIG_DIR.resolve(to).toFile();
            if (fromFile == null || toFile == null || toFile.exists()) continue;
            try {
                FileUtils.copyURLToFile((URL)fromFile.toUri().toURL(), (File)toFile);
            }
            catch (IOException e) {
                CristelLib.LOGGER.error("Couldn't copy file from: " + String.valueOf(fromFile) + " to: " + String.valueOf(toFile), (Throwable)e);
            }
        }
    }

    public static void getStructureConfigs(String modId, Map<String, Set<StructureConfig>> modIdAndConfigs, CristelLibRegistry registry) {
        HashSet<StructureConfig> configs = new HashSet<StructureConfig>();
        for (Path path : ReadData.getPathsInDir(modId, "structure_configs")) {
            String header;
            InputStream stream;
            try {
                stream = Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
            if (!(element instanceof JsonObject)) continue;
            JsonObject object = (JsonObject)element;
            String subPath = object.get("subPath").getAsString();
            String name = object.get("name").getAsString();
            StructureConfig config = StructureConfig.createWithDefaultConfigPath(subPath, name, ConfigType.valueOf(object.get("config_type").getAsString().toUpperCase()));
            JsonArray sets = object.get("structure_sets").getAsJsonArray();
            for (JsonElement e : sets) {
                JsonObject o;
                if (!(e instanceof JsonObject) || !(o = (JsonObject)e).has("structure_set") || !o.has("modid")) continue;
                String mS = o.get("modid").getAsString();
                JsonArray array = o.get("structure_set").getAsJsonArray();
                for (JsonElement s : array) {
                    if (!(s instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)s;
                    registry.registerSetToConfig(mS, class_2960.method_12829((String)primitive.getAsString()), config);
                }
            }
            if (object.has("header") && !(header = object.get("header").getAsString()).isEmpty()) {
                config.setHeader(header + "\n");
            }
            if (object.has("comments")) {
                JsonObject comments = object.get("comments").getAsJsonObject();
                HashMap<String, String> commentFinalMap = new HashMap<String, String>();
                Map commentMap = comments.asMap();
                for (String s : commentMap.keySet()) {
                    Object v = commentMap.get(s);
                    if (!(v instanceof JsonPrimitive)) continue;
                    JsonPrimitive p = (JsonPrimitive)v;
                    commentFinalMap.put(s, p.getAsString());
                }
                if (!commentFinalMap.isEmpty()) {
                    config.setComments(commentFinalMap);
                }
            }
            configs.add(config);
        }
        checkedConfigFiles = false;
        if (configs.isEmpty()) {
            return;
        }
        modIdAndConfigs.put(modId, configs);
    }

    public static List<Path> getPathsInDir(String modId, String subPath) {
        ArrayList<Path> paths = new ArrayList<Path>();
        ReadData.findFiles(CristelLibExpectPlatform.getRootPaths(modId), modId, subPath, x$0 -> Files.exists(x$0, new LinkOption[0]), (path, file) -> {
            if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")) {
                paths.add((Path)file);
            }
            return true;
        }, true, Integer.MAX_VALUE);
        return paths;
    }

    public static void findFiles(List<Path> rootPaths, String modId, String subPath, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) {
        if (modId.equals("minecraft")) {
            return;
        }
        if (!checkedConfigFiles) {
            ReadData.findInConfigFiles(subPath, rootFilter, processor, visitAllFiles, maxDepth);
            checkedConfigFiles = true;
        }
        try {
            for (Path root : rootPaths) {
                ReadData.walk(root.resolve(String.format("data/cristellib/%s", subPath)), rootFilter, processor, visitAllFiles, maxDepth);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void findInConfigFiles(String subPath, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) {
        try {
            ReadData.walk(ConfigUtil.CONFIG_LIB.resolve(String.format("data/%s", subPath)), rootFilter, processor, visitAllFiles, maxDepth);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void walk(Path root, Predicate<Path> rootFilter, BiFunction<Path, Path, Boolean> processor, boolean visitAllFiles, int maxDepth) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0]) || !rootFilter.test(root)) {
            return;
        }
        if (processor != null) {
            try (Stream<Path> stream = Files.walk(root, maxDepth, new FileVisitOption[0]);){
                Iterator itr = stream.iterator();
                while (itr.hasNext()) {
                    boolean keepGoing = processor.apply(root, (Path)itr.next());
                    if (visitAllFiles || keepGoing) continue;
                    return;
                }
            }
        }
    }
}

