/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.PieceEntry;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;

public class BiomeCondition
extends StructureCondition {
    public static final MapCodec<BiomeCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_6862.method_40090((class_5321)class_7924.field_41236).fieldOf("biome_tag").forGetter(condition -> condition.biomeTag), (App)class_2338.field_25064.optionalFieldOf("offset", (Object)class_2338.field_10980).forGetter(condition -> condition.offset)).apply((Applicative)builder, BiomeCondition::new));
    public final class_6862<class_1959> biomeTag;
    public final class_2338 offset;

    public BiomeCondition(class_6862<class_1959> biome, class_2338 offset) {
        this.biomeTag = biome;
        this.offset = offset;
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.BIOME;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        class_1966 biomeSource = ctx.biomeSource();
        PieceEntry pieceEntry = ctx.pieceEntry();
        class_7138 randomState = ctx.randomState();
        if (biomeSource == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'biomeSource' for biome condition!");
        }
        if (pieceEntry == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieceEntry' for biome condition!");
        }
        if (randomState == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'randomState' for biome condition!");
        }
        if (biomeSource == null || pieceEntry == null || randomState == null) {
            return false;
        }
        class_2338 checkPos = pieceEntry.getPiece().method_16648().method_10081((class_2382)this.offset);
        class_6880 biome = biomeSource.method_38109(class_5742.method_33100((int)checkPos.method_10263()), class_5742.method_33100((int)checkPos.method_10264()), class_5742.method_33100((int)checkPos.method_10260()), randomState.method_42371());
        return biome.method_40220(this.biomeTag);
    }
}

