/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.EntryListPane;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ScrollableListControl
extends EntryListPane<StringEntry> {
    public static final int DEFAULT_SLOT_HEIGHT = 18;
    public String currentValue;
    public List<String> itemList;

    public ScrollableListControl(@Nonnull class_310 mc, ExtendedScreen parentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        super(mc, width, height, topIn, slotHeightIn);
        this.setParent(parentScreen);
        this.setList(itemList);
        this.currentValue = currentValue;
    }

    public ScrollableListControl(@Nonnull class_310 mc, ExtendedScreen parentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue) {
        this(mc, parentScreen, width, height, topIn, bottomIn, 18, itemList, currentValue);
    }

    @Override
    public void setSelected(StringEntry entry) {
        super.setSelected(entry);
        if (entry != null) {
            this.currentValue = entry.name;
        }
    }

    @Override
    protected int getItemCount() {
        return this.itemList.size();
    }

    public boolean setList(List<String> itemList) {
        if (itemList == null) {
            itemList = StringUtils.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.scrollBy(-2.1474836E9f);
            if (this.isLoaded()) {
                this.syncEntries();
            }
            return true;
        }
        return false;
    }

    @Override
    public void refreshContentHeight() {
        super.refreshContentHeight();
        this.syncEntries();
    }

    public void syncEntries() {
        this.clearEntries();
        for (String item : StringUtils.newArrayList(this.itemList)) {
            StringEntry dataEntry = new StringEntry(item);
            this.addEntry(dataEntry);
            if (!item.equals(this.currentValue)) continue;
            this.setSelected(dataEntry);
        }
        if (this.getSelected() != null) {
            this.centerScrollOn((StringEntry)this.getSelected());
        }
    }

    public void renderSlotItem(@Nonnull class_332 matrices, String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn, boolean hovered, float partialTicks) {
        RenderUtils.renderScrollingString(matrices, this.getGameInstance(), this.getFontRenderer(), originalName, xPos + RenderUtils.getStringWidth(this.getFontRenderer(), originalName) / 2, xPos, yPos, xPos + widthIn - 4, yPos + heightIn, 0xFFFFFF);
    }

    public class StringEntry
    extends EntryListPane.Entry<StringEntry> {
        private final String name;

        public StringEntry(String name) {
            this.name = name;
        }

        @Override
        public void render(@Nonnull class_332 matrices, class_310 client, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ScrollableListControl.this.renderSlotItem(matrices, this.name, xPos, yPos, entryWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (ScrollableListControl.this.isValidMouseClick(button)) {
                this.onPressed();
                return true;
            }
            return false;
        }

        private void onPressed() {
            ScrollableListControl.this.setSelected(this);
        }

        @Override
        public class_2561 getNarration() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.name});
        }
    }
}

