/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.world.item;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancements.trigger.FramePrintedTrigger;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.server.CameraInstances;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.component.FocalRange;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.camera.Flash;
import io.github.mortuusars.exposure.world.item.camera.Shutter;
import io.github.mortuusars.exposure_polaroid.Config;
import io.github.mortuusars.exposure_polaroid.ExposurePolaroid;
import io.github.mortuusars.exposure_polaroid.world.camera.PolaroidFrameExtraData;
import io.github.mortuusars.exposure_polaroid.world.item.camera.InstantCameraAttachment;
import io.github.mortuusars.exposure_polaroid.world.item.camera.InstantCameraShutter;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantCameraItem
extends CameraItem {
    public static final class_2960 CAPTURE_TYPE = ExposurePolaroid.resource("instant_camera");

    public InstantCameraItem(class_1792.class_1793 properties) {
        super(properties);
    }

    protected Shutter createShutter() {
        return new InstantCameraShutter();
    }

    protected Flash createFlash() {
        return new Flash(this){

            public boolean isAvailable(class_1799 camera) {
                return true;
            }
        };
    }

    protected List<ShutterSpeed> defineShutterSpeeds() {
        return List.of(new ShutterSpeed("1/200"), new ShutterSpeed("1/111"), new ShutterSpeed("1/78"), new ShutterSpeed("1/60"), new ShutterSpeed("1/30"), new ShutterSpeed("1/20"), new ShutterSpeed("1/15"));
    }

    @NotNull
    protected List<Attachment<?>> defineAttachments() {
        return List.of(InstantCameraAttachment.INSTANT_SLIDE);
    }

    public Attachment<?> getFilmAttachment() {
        return InstantCameraAttachment.INSTANT_SLIDE;
    }

    public boolean hasAttachmentsMenu() {
        return false;
    }

    public class_2960 getCaptureType(class_1799 stack) {
        return CAPTURE_TYPE;
    }

    public float getScaleOnStand() {
        return 0.85f;
    }

    public class_3414 getViewfinderOpenSound() {
        return ExposurePolaroid.SoundEvents.INSTANT_CAMERA_VIEWFINDER_OPEN.get();
    }

    public class_3414 getViewfinderCloseSound() {
        return ExposurePolaroid.SoundEvents.INSTANT_CAMERA_VIEWFINDER_CLOSE.get();
    }

    public FocalRange getFocalRange(class_5455 registryAccess, class_1799 stack) {
        if (!Attachment.LENS.isEmpty(stack)) {
            return Attachment.LENS.map(stack, lensStack -> Lenses.getFocalRange((class_5455)registryAccess, (class_1799)lensStack).orElse(FocalRange.parse((String)((String)Config.Server.INSTANT_CAMERA_FOCAL_RANGE.get())))).orElse(FocalRange.parse((String)((String)Config.Server.INSTANT_CAMERA_FOCAL_RANGE.get())));
        }
        return FocalRange.parse((String)((String)Config.Server.INSTANT_CAMERA_FOCAL_RANGE.get()));
    }

    public double getYPositionOffset(class_1799 stack) {
        return 0.0;
    }

    public float getCropFactor() {
        return 0.75f;
    }

    public int getMaxSlideCount() {
        return (Integer)InstantCameraAttachment.INSTANT_SLIDE.maxCount().get();
    }

    public int getRemainingSlides(class_1799 stack) {
        return InstantCameraAttachment.INSTANT_SLIDE.get(stack).getForReading().method_7947();
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return (Boolean)Config.Client.INSTANT_CAMERA_SHOW_FULLNESS_BAR_ON_ITEM.get() != false && !InstantCameraAttachment.INSTANT_SLIDE.isEmpty(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        return InstantCameraAttachment.INSTANT_SLIDE.map(stack, this::getSlideFullness).orElse(0);
    }

    protected int getSlideFullness(class_1799 stack) {
        return Math.min(1 + 12 * stack.method_7947() / this.getMaxSlideCount(), 13);
    }

    public int method_31571(@NotNull class_1799 stack) {
        class_1799 slide = InstantCameraAttachment.INSTANT_SLIDE.get(stack).getForReading();
        int max = this.getMaxSlideCount();
        float f = Math.max(0.0f, (float)slide.method_7947() / (float)max);
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> components, class_1836 tooltipFlag) {
        if (((Boolean)Config.Client.INSTANT_CAMERA_SHOW_SLIDES_COUNT_IN_TOOLTIP.get()).booleanValue()) {
            InstantCameraAttachment.INSTANT_SLIDE.ifPresent(stack, (slideItem, slideStack) -> {
                int exposed = slideStack.method_7947();
                int max = this.getMaxSlideCount();
                components.add((class_2561)class_2561.method_43469((String)"item.exposure_polaroid.instant_camera.tooltip.slides", (Object[])new Object[]{exposed, max}));
            });
        }
        if (((Boolean)Config.Client.INSTANT_CAMERA_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            if (stack.method_27319() instanceof CameraStandEntity) {
                if (class_437.method_25442()) {
                    components.add((class_2561)class_2561.method_43471((String)"item.exposure_polaroid.instant_camera.tooltip.details_insert_on_stand"));
                    components.add((class_2561)class_2561.method_43471((String)"item.exposure_polaroid.instant_camera.tooltip.details_remove_on_stand"));
                } else {
                    components.add((class_2561)class_2561.method_43471((String)"tooltip.exposure.hold_for_details"));
                }
                return;
            }
            if (class_437.method_25442()) {
                components.add((class_2561)class_2561.method_43471((String)"item.exposure_polaroid.instant_camera.tooltip.details_insert"));
                components.add((class_2561)class_2561.method_43471((String)"item.exposure_polaroid.instant_camera.tooltip.details_remove"));
            } else {
                components.add((class_2561)class_2561.method_43471((String)"tooltip.exposure.hold_for_details"));
            }
        }
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (this.getShutter().isOpen(stack) || this.isOnCooldown((CameraHolder)player, stack)) {
            return true;
        }
        class_1269 hotswap = this.hotswap((CameraHolder)player, stack, otherStack, access);
        if (hotswap == class_1269.field_5814) {
            return true;
        }
        if (hotswap.method_23665()) {
            if (player.method_7337()) {
                Minecrft.gameMode().method_2909(stack, slot.field_7874);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        CameraItem offhandCameraItem;
        class_1792 class_17922;
        class_1799 stack = player.method_5998(hand);
        if (hand == class_1268.field_5808 && (class_17922 = player.method_6079().method_7909()) instanceof CameraItem && (offhandCameraItem = (CameraItem)class_17922).isActive(player.method_6079())) {
            return class_1271.method_22430((Object)stack);
        }
        if (!this.isActive(stack)) {
            return this.activateInHand(player, stack, hand);
        }
        return this.release((CameraHolder)player, stack);
    }

    public class_1269 handleStandSneakInteraction(CameraStandEntity stand, class_1657 player, class_1268 hand, class_1799 cameraStack) {
        return super.handleStandSneakInteraction(stand, player, hand, cameraStack);
    }

    public boolean canTakePhoto(CameraHolder holder, class_1799 stack) {
        return !this.isOnCooldown(holder, stack) && !this.getTimer().isTicking(holder, stack) && !this.getShutter().isOpen(stack) && !InstantCameraAttachment.INSTANT_SLIDE.isEmpty(stack) && CameraInstances.canReleaseShutter((CameraId)CameraId.ofStack((class_1799)stack));
    }

    public int calculateCooldownAfterShot(class_1799 stack, CaptureParameters captureParameters) {
        return 40;
    }

    public boolean tick(CameraHolder holder, class_1799 stack) {
        boolean changed = super.tick(holder, stack);
        @Nullable Frame frame = (Frame)stack.method_57824(Exposure.DataComponents.PHOTOGRAPH_FRAME);
        if (frame != null && !this.getShutter().isOpen(stack) && !this.isOnCooldown(holder, stack)) {
            stack.method_57381(Exposure.DataComponents.PHOTOGRAPH_FRAME);
            this.printPhotograph(holder, stack, frame);
            return true;
        }
        return changed;
    }

    protected void printPhotograph(CameraHolder holder, class_1799 stack, Frame frame) {
        class_1297 holderEntity = holder.asHolderEntity();
        class_1937 level = holderEntity.method_37908();
        ExposureType type = InstantCameraAttachment.INSTANT_SLIDE.map(stack, (i, s) -> i.getType()).orElse(ExposureType.COLOR);
        class_1799 photograph = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
        photograph.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
        photograph.method_57379(Exposure.DataComponents.PHOTOGRAPH_TYPE, (Object)type);
        if (holder instanceof class_1657) {
            class_1542 itemEntity;
            class_1657 player = (class_1657)holder;
            if (!player.method_7337()) {
                class_1799 slide = InstantCameraAttachment.INSTANT_SLIDE.get(stack).getCopy();
                slide.method_7934(1);
                slide = slide.method_7960() ? class_1799.field_8037 : slide;
                InstantCameraAttachment.INSTANT_SLIDE.set(stack, slide);
            }
            boolean placedInInventory = false;
            for (int slot = 0; slot < player.method_31548().field_7547.size(); ++slot) {
                class_1799 item = player.method_31548().method_5438(slot);
                if (item.method_7960()) {
                    player.method_31548().method_5447(slot, photograph);
                    photograph.method_7912(5);
                    placedInInventory = true;
                } else if (item.method_7909() instanceof PhotographItem) {
                    StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)Exposure.Items.STACKED_PHOTOGRAPHS.get();
                    class_1799 stackedPhotographsStack = new class_1799((class_1935)stackedPhotographsItem);
                    stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, item);
                    stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, photograph);
                    player.method_31548().method_5447(slot, stackedPhotographsStack);
                    stackedPhotographsStack.method_7912(5);
                    placedInInventory = true;
                } else {
                    StackedPhotographsItem stackedPhotographs;
                    class_1792 class_17922 = item.method_7909();
                    if (class_17922 instanceof StackedPhotographsItem && (stackedPhotographs = (StackedPhotographsItem)class_17922).canAddPhotograph(item)) {
                        stackedPhotographs.addPhotographOnTop(item, photograph);
                        item.method_7912(5);
                        placedInInventory = true;
                    }
                }
                if (!placedInInventory) continue;
                level.method_43129(player, (class_1297)player, (class_3414)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.6f, level.method_8409().method_43057() * 0.2f + 0.9f);
                break;
            }
            if (!level.field_9236 && !placedInInventory && (itemEntity = player.method_7329(photograph, true, false)) != null) {
                itemEntity.method_6982(5);
            }
        } else {
            class_1799 slide = InstantCameraAttachment.INSTANT_SLIDE.get(stack).getCopy();
            slide.method_7934(1);
            slide = slide.method_7960() ? class_1799.field_8037 : slide;
            InstantCameraAttachment.INSTANT_SLIDE.set(stack, slide);
            if (!photograph.method_7960() && !level.method_8608()) {
                class_243 look = holderEntity.method_5720().method_1021((double)0.2f);
                class_243 pos = holderEntity.method_33571();
                class_1542 itemEntity = new class_1542(level, pos.field_1352 + look.field_1352 * 2.0, pos.field_1351 + look.field_1351 * 2.0 - (double)0.3f, pos.field_1350 + look.field_1350 * 2.0, photograph, look.field_1352 * 0.5, look.field_1351 * 0.5, look.field_1350 * 0.5);
                itemEntity.method_6982(5);
                level.method_8649((class_1297)itemEntity);
            }
        }
        holder.getServerPlayerAwardedForExposure().ifPresent(serverPlayer -> ((FramePrintedTrigger)Exposure.CriteriaTriggers.FRAME_PRINTED.get()).trigger(serverPlayer, holderEntity.method_24515(), frame, photograph));
        if (!level.field_9236) {
            level.method_43129(null, holderEntity, (class_3414)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.6f, level.method_8409().method_43057() * 0.2f + 1.2f);
        }
    }

    protected void addFrameExtraData(CameraHolder holder, class_3218 level, class_1799 camera, CaptureParameters captureParameters, List<class_2338> positionsInFrame, List<class_1309> entitiesInFrame, ExtraData data) {
        data.put(PolaroidFrameExtraData.INSTANT, (Object)true);
        super.addFrameExtraData(holder, level, camera, captureParameters, positionsInFrame, entitiesInFrame, data);
    }

    public void addFrameToFilm(class_1799 stack, Frame frame) {
        stack.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
    }
}

