/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.emi.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.emi.common.AbstractEmiRecipeHandler;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5684;

class PatternGridEmiRecipeHandler
extends AbstractEmiRecipeHandler<PatternGridContainerMenu> {
    private static final List<class_5684> ALL_AUTOCRAFTABLE_TOOLTIP = List.of(PatternGridEmiRecipeHandler.createAutocraftableHint((class_2561)class_2561.method_43471((String)"gui.%s.transfer.all_autocraftable".formatted("refinedstorage_emi_integration"))));
    private static final List<class_5684> SOME_AUTOCRAFTABLE_TOOLTIP = List.of(PatternGridEmiRecipeHandler.createAutocraftableHint((class_2561)class_2561.method_43471((String)"gui.%s.transfer.some_autocraftable".formatted("refinedstorage_emi_integration"))));

    PatternGridEmiRecipeHandler() {
    }

    public EmiPlayerInventory getInventory(class_465<PatternGridContainerMenu> screen) {
        return new EmiPlayerInventory(List.of());
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        return true;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING) {
            this.transferCraftingRecipe(recipe, context);
        } else if (recipe.getCategory() == VanillaEmiRecipeCategories.STONECUTTING) {
            this.transferStonecutterRecipe(recipe, context);
        } else if (recipe.getCategory() == VanillaEmiRecipeCategories.SMITHING) {
            this.transferSmithingTableRecipe(recipe, context);
        } else {
            this.transferProcessingRecipe(recipe, context);
        }
        return true;
    }

    private void transferCraftingRecipe(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        List<List> inputs = recipe.getInputs().stream().map(this::getItems).toList();
        ((PatternGridContainerMenu)context.getScreenHandler()).transferCraftingRecipe(inputs);
    }

    private void transferStonecutterRecipe(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        List<List> inputs = recipe.getInputs().stream().map(this::getItems).toList();
        List<List> outputs = recipe.getOutputs().stream().map(this::getItems).toList();
        if (!(inputs.isEmpty() || outputs.isEmpty() || inputs.getFirst().isEmpty() || outputs.getFirst().isEmpty())) {
            ((PatternGridContainerMenu)context.getScreenHandler()).transferStonecutterRecipe((ItemResource)inputs.getFirst().getFirst(), (ItemResource)outputs.getFirst().getFirst());
        }
    }

    private void transferSmithingTableRecipe(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        List<List> inputs = recipe.getInputs().stream().map(this::getItems).toList();
        if (inputs.size() == 3) {
            ((PatternGridContainerMenu)context.getScreenHandler()).transferSmithingTableRecipe(inputs.getFirst(), inputs.get(1), inputs.get(2));
        }
    }

    private List<ItemResource> getItems(EmiIngredient ingredient) {
        return ingredient.getEmiStacks().stream().map(EmiStack::getItemStack).filter(stack -> !stack.method_7960()).map(ItemResource::ofItemStack).collect(Collectors.toList());
    }

    private void transferProcessingRecipe(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        List<List> inputs = recipe.getInputs().stream().map(PatternGridEmiRecipeHandler::getResourceAmounts).toList();
        List<List> outputs = recipe.getOutputs().stream().map(PatternGridEmiRecipeHandler::getResourceAmounts).toList();
        ((PatternGridContainerMenu)context.getScreenHandler()).transferProcessingRecipe(inputs, outputs);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> craftContext, List<Widget> widgets, class_332 draw) {
        EmiDrawContext context = EmiDrawContext.wrap((class_332)draw);
        RenderSystem.enableDepthTest();
        ResourceRepository repository = ((PatternGridContainerMenu)craftContext.getScreenHandler()).getRepository();
        for (Widget widget : widgets) {
            boolean autocraftable;
            if (!(widget instanceof SlotWidget)) continue;
            SlotWidget slotWidget = (SlotWidget)widget;
            EmiIngredient stack = slotWidget.getStack();
            Bounds bounds = slotWidget.getBounds();
            if (slotWidget.getRecipe() != null || stack.isEmpty() || !(autocraftable = PatternGridEmiRecipeHandler.getResourceAmounts(stack).stream().anyMatch(resourceAmount -> repository.isSticky(resourceAmount.resource())))) continue;
            context.fill(bounds.x(), bounds.y(), bounds.width(), bounds.height(), AUTOCRAFTABLE_COLOR);
        }
    }

    public List<class_5684> getTooltip(EmiRecipe recipe, EmiCraftContext<PatternGridContainerMenu> context) {
        ResourceRepository view = ((PatternGridContainerMenu)context.getScreenHandler()).getRepository();
        List<List> inputs = recipe.getInputs().stream().filter(input -> !input.isEmpty()).map(PatternGridEmiRecipeHandler::getResources).toList();
        boolean allAutocraftable = inputs.stream().allMatch(possibilities -> possibilities.stream().anyMatch(arg_0 -> ((ResourceRepository)view).isSticky(arg_0)));
        if (allAutocraftable) {
            return ALL_AUTOCRAFTABLE_TOOLTIP;
        }
        boolean someAutocraftable = inputs.stream().anyMatch(possibilities -> possibilities.stream().anyMatch(arg_0 -> ((ResourceRepository)view).isSticky(arg_0)));
        if (someAutocraftable) {
            return SOME_AUTOCRAFTABLE_TOOLTIP;
        }
        return Collections.emptyList();
    }

    private static List<ResourceAmount> getResourceAmounts(EmiIngredient ingredient) {
        return ingredient.getEmiStacks().stream().flatMap(emiStack -> RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResourceAmount(emiStack).stream()).collect(Collectors.toList());
    }

    private static List<ResourceKey> getResources(EmiIngredient ingredient) {
        return ingredient.getEmiStacks().stream().flatMap(emiStack -> RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResourceAmount(emiStack).stream()).map(ResourceAmount::resource).collect(Collectors.toList());
    }
}

