/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.emi.common;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.class_1703;
import net.minecraft.class_332;
import net.minecraft.class_437;

class ResourceEmiDragDropHandler
implements EmiDragDropHandler<class_437> {
    ResourceEmiDragDropHandler() {
    }

    public boolean dropStack(class_437 screen, EmiIngredient stack, int x, int y) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return false;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        class_1703 class_17032 = baseScreen.method_17577();
        if (!(class_17032 instanceof AbstractResourceContainerMenu)) {
            return false;
        }
        AbstractResourceContainerMenu menu = (AbstractResourceContainerMenu)class_17032;
        return RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource((Object)stack).map(resource -> this.dropStack(menu, (AbstractBaseScreen<?>)baseScreen, (PlatformResourceKey)resource, x, y)).orElse(false);
    }

    private boolean dropStack(AbstractResourceContainerMenu menu, AbstractBaseScreen<?> baseScreen, PlatformResourceKey resource, int x, int y) {
        for (ResourceSlot slot : menu.getResourceSlots()) {
            if (!this.dropStack(resource, slot, x, y, baseScreen)) continue;
            return true;
        }
        return false;
    }

    private boolean dropStack(PlatformResourceKey resource, ResourceSlot slot, int x, int y, AbstractBaseScreen<?> baseScreen) {
        if (!ResourceEmiDragDropHandler.isSlotValid(resource, slot)) {
            return false;
        }
        int slotX = baseScreen.getLeftPos() + slot.field_7873;
        int slotY = baseScreen.getTopPos() + slot.field_7872;
        if (x < slotX || y < slotY || x > slotX + 16 || y > slotY + 16) {
            return false;
        }
        C2SPackets.sendResourceFilterSlotChange((PlatformResourceKey)resource, (int)slot.field_7874);
        return true;
    }

    public void render(class_437 screen, EmiIngredient dragged, class_332 draw, int mouseX, int mouseY, float delta) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        class_1703 class_17032 = baseScreen.method_17577();
        if (!(class_17032 instanceof AbstractResourceContainerMenu)) {
            return;
        }
        AbstractResourceContainerMenu menu = (AbstractResourceContainerMenu)class_17032;
        RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource((Object)dragged).ifPresent(resource -> {
            EmiDrawContext context = EmiDrawContext.wrap((class_332)draw);
            for (ResourceSlot slot : menu.getResourceSlots()) {
                if (!ResourceEmiDragDropHandler.isSlotValid(resource, slot)) continue;
                context.fill(baseScreen.getLeftPos() + slot.field_7873, baseScreen.getTopPos() + slot.field_7872, 17, 17, -2010989773);
            }
        });
    }

    private static boolean isSlotValid(PlatformResourceKey resource, ResourceSlot slot) {
        return slot.isFilter() && slot.method_7682() && slot.isValid((ResourceKey)resource);
    }
}

