/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.Track;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class Melody
extends MelodyDescriptor {
    public static final Melody DEFAULT = new Melody();
    private final List<Track> tracks = new LinkedList<Track>();
    public static class_9139<class_2540, Melody> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, MelodyDescriptor::getName, (class_9139)Track.STREAM_CODEC.method_56433(class_9135.method_56363()), Melody::getTracks, Melody::new);

    public Melody() {
        super("unknown");
        this.addTrack(new Track("unknown", new LinkedList<Note>()));
    }

    public Melody(String name, List<Track> tracks) {
        super(name);
        this.tracks.addAll(tracks);
    }

    public List<Track> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    public int getLength() {
        int length = 0;
        for (Track track : this.tracks) {
            length = Math.max(length, track.getLength());
        }
        return length;
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
    }

    public void trim() {
        int offset = this.getFirstNoteTime();
        for (Track track : this.tracks) {
            LinkedList<Note> newNotes = new LinkedList<Note>();
            for (Note note : track.getNotes()) {
                newNotes.add(new Note(note.getNote(), note.getVelocity(), note.getTime() - offset, note.getLength(), note.getSustain()));
            }
            track.setNotes(newNotes);
        }
    }

    private int getFirstNoteTime() {
        int earliestNote = Integer.MAX_VALUE;
        for (Track track : this.tracks) {
            List<Note> notes = track.getNotes();
            if (notes.isEmpty()) continue;
            earliestNote = Math.min(earliestNote, notes.getFirst().getTime());
        }
        return earliestNote;
    }
}

