/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import immersive_melodies.Config;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.MidiParser;
import immersive_melodies.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public class MelodyLoader
extends class_4080<Map<class_2960, LazyMelody>> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                val = value.updateAndGet(arg_0 -> MelodyLoader.lambda$memoize$0((Supplier)delegate, arg_0));
            }
            return val;
        };
    }

    protected Map<class_2960, LazyMelody> prepare(class_3300 manager, class_3695 profiler) {
        HashMap map = Maps.newHashMap();
        HashMap resources = new HashMap();
        resources.putAll(manager.method_14488("melodies", MelodyLoader::filter));
        resources.putAll(manager.method_14488("melody", MelodyLoader::filter));
        for (Map.Entry entry : resources.entrySet()) {
            if (!Config.getInstance().loadInbuiltMidis && ((class_2960)entry.getKey()).method_12836().equals("immersive_melodies")) continue;
            try {
                String name = Utils.toTitle(Utils.removeLastPart(Utils.getLastPart(((class_2960)entry.getKey()).method_12832(), "/"), "."));
                class_2960 identifier = class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)((class_2960)entry.getKey()).method_12832());
                map.put(identifier, new LazyMelody(name, () -> {
                    try {
                        return MidiParser.parseMidi(((class_3298)entry.getValue()).method_14482(), name);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load melody {} ({})", entry.getKey(), (Object)exception);
            }
        }
        return map;
    }

    private static boolean filter(class_2960 path) {
        return path.method_12832().endsWith(".midi") || path.method_12832().endsWith(".mid");
    }

    protected void apply(Map<class_2960, LazyMelody> prepared, class_3300 manager, class_3695 profiler) {
        ServerMelodyManager.setDatapackMelodies(prepared);
    }

    private static /* synthetic */ Object lambda$memoize$0(Supplier delegate, Object cur) {
        return cur == null ? Objects.requireNonNull(delegate.get()) : cur;
    }

    public static class LazyMelody {
        public final String name;
        public final Supplier<Melody> supplier;
        public final MelodyDescriptor descriptor;

        public LazyMelody(String name, Supplier<Melody> supplier) {
            this.name = name;
            this.supplier = MelodyLoader.memoize(supplier);
            this.descriptor = new MelodyDescriptor(name);
        }

        public Melody get() {
            return this.supplier.get();
        }

        public MelodyDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

