/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.wizards.content.WizardSpells;
import net.wizards.content.WizardsSounds;
import net.wizards.item.Armors;
import net.wizards.item.Weapons;

public class WizardsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SoundGen::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.wizardRobeSet, class_1802.field_8759);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.arcaneRobeSet, class_1802.field_8634);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.fireRobeSet, class_1802.field_8183);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.frostRobeSet, class_1802.field_8662);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netherite_arcane, class_1802.field_22021);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netherite_fire, class_1802.field_22021);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netherite_frost, class_1802.field_22021);
            UnsmeltGenerator.disassemble(exporter, List.of(Weapons.arcaneWand.item(), Weapons.fireWand.item()), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, List.of(Weapons.frostWand.item()), class_1802.field_8675);
            UnsmeltGenerator.disassemble(exporter, List.of(Weapons.arcaneStaff.item()), class_1802.field_27063);
            UnsmeltGenerator.disassemble(exporter, List.of(Weapons.fireStaff.item()), class_1802.field_8183);
            UnsmeltGenerator.disassemble(exporter, List.of(Weapons.frostStaff.item()), class_1802.field_8434);
            UnsmeltGenerator.disassemble(exporter, Weapons.entries.stream().filter(entry -> entry.id().method_12832().contains("netherite")).map(entry -> entry.item()).toList(), class_1802.field_22021);
        }

        private static void disassembleArmor(class_8790 exporter, Armor.Set armorSet, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(class_8790 exporter, List<class_1935> items, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("wizards", WizardsSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().method_12832(), (int)entry.variants())).toList()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (WizardSpells.Entry entry : WizardSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateWeaponTags(Weapons.entries);
            this.generateArmorTags(Armors.entries, RPGSeriesItemTags.ArmorMetaType.MAGIC);
        }
    }
}

