/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.jei;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.screen.ItemTrashCanScreen;
import com.supermartijn642.trashcans.screen.LiquidTrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanWidgetContainerScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_768;

public class GhostIngredientHandler
implements IGhostIngredientHandler<TrashCanWidgetContainerScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(TrashCanWidgetContainerScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        TrashCanScreen<?> widget = screen.getWidget();
        TrashCanContainer container = screen.getContainer();
        ArrayList<class_1735> itemFilterSlots = new ArrayList<class_1735>();
        ArrayList<class_1735> fluidFilterSlots = new ArrayList<class_1735>();
        if (widget instanceof ItemTrashCanScreen) {
            for (slot = 1; slot <= 9; ++slot) {
                itemFilterSlots.add(container.method_7611(slot));
            }
        } else if (widget instanceof LiquidTrashCanScreen) {
            for (slot = 1; slot <= 9; ++slot) {
                fluidFilterSlots.add(container.method_7611(slot));
            }
        } else if (widget instanceof UltimateTrashCanScreen) {
            for (slot = 3; slot <= 11; ++slot) {
                itemFilterSlots.add(container.method_7611(slot));
            }
            for (slot = 12; slot <= 20; ++slot) {
                fluidFilterSlots.add(container.method_7611(slot));
            }
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            for (int i = 0; i < itemFilterSlots.size(); ++i) {
                int index = i;
                class_1735 slot = (class_1735)itemFilterSlots.get(i);
                class_768 bounds = new class_768(screen.getWidget().left() + slot.field_7873, screen.getWidget().top() + slot.field_7872, 17, 17);
                IGhostIngredientHandler.Target<Object> target = GhostIngredientHandler.createTarget(bounds, input -> {
                    TrashCanBlockEntity entity = container.getBlockEntity();
                    if (entity != null) {
                        entity.itemFilter.set(index, (class_1799)input);
                        TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeItemFilter(container.getBlockEntityPos(), index, (class_1799)input));
                    }
                });
                targets.add(target);
            }
        }
        class_1799 ingredientStack = class_1799.field_8037;
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ingredientStack = (class_1799)ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).get();
        } else if (ingredient.getType() == FabricTypes.FLUID_STACK) {
            ingredientStack = ((IJeiFluidIngredient)ingredient.getIngredient((IIngredientType)FabricTypes.FLUID_STACK).get()).getFluidVariant().getFluid().method_15774().method_7854();
        }
        ItemFilter filter = LiquidTrashCanFilters.createFilter(ingredientStack);
        if (filter != null) {
            for (int i = 0; i < fluidFilterSlots.size(); ++i) {
                int index = i;
                class_1735 slot = (class_1735)fluidFilterSlots.get(i);
                class_768 bounds = new class_768(screen.getWidget().left() + slot.field_7873, screen.getWidget().top() + slot.field_7872, 17, 17);
                IGhostIngredientHandler.Target<Object> target = GhostIngredientHandler.createTarget(bounds, input -> {
                    TrashCanBlockEntity entity = container.getBlockEntity();
                    if (entity != null) {
                        entity.liquidFilter.set(index, filter);
                        TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeLiquidFilter(container.getBlockEntityPos(), index, filter));
                    }
                });
                targets.add(target);
            }
        }
        return targets;
    }

    private static <I> IGhostIngredientHandler.Target<I> createTarget(final class_768 bounds, final Consumer<I> acceptor) {
        return new IGhostIngredientHandler.Target<I>(){

            public class_768 getArea() {
                return bounds;
            }

            public void accept(I ingredient) {
                acceptor.accept(ingredient);
            }
        };
    }

    public void onComplete() {
    }
}

