/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9323;

public interface SelectableResource<T> {
    public static SelectableResource<class_1799> item(class_1799 stack) {
        return new ItemStackResource(stack);
    }

    public static SelectableResource<FluidStack> fluid(FluidStack stack) {
        return new FluidStackResource(stack);
    }

    public T stack();

    public long getCount();

    public void setCount(int var1);

    default public boolean isEmpty() {
        return this.getCount() == 0L;
    }

    public class_2561 getName();

    public Icon getIcon();

    public SelectableResource<T> copyWithCount(long var1);

    public class_2487 getComponentsTag();

    public void applyComponentsTag(class_2487 var1);

    public static final class ItemStackResource
    extends Record
    implements SelectableResource<class_1799> {
        private final class_1799 stack;

        public ItemStackResource(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public long getCount() {
            return this.stack.method_7947();
        }

        @Override
        public void setCount(int count) {
            this.stack.method_7939(count);
        }

        @Override
        public class_2561 getName() {
            return this.stack.method_7964();
        }

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(this.stack);
        }

        @Override
        public SelectableResource<class_1799> copyWithCount(long count) {
            return SelectableResource.item(this.stack.method_46651((int)count));
        }

        @Override
        public class_2487 getComponentsTag() {
            class_2487 t;
            class_2520 tag = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.stack.method_57353()).result().orElse(new class_2487());
            return tag instanceof class_2487 ? (t = (class_2487)tag) : null;
        }

        @Override
        public void applyComponentsTag(class_2487 tag) {
            class_9323.field_50234.parse((DynamicOps)class_2509.field_11560, (Object)tag).result().ifPresent(arg_0 -> ((class_1799)this.stack).method_57365(arg_0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemStackResource.class, "stack", "stack"}, this, o);
        }

        @Override
        public class_1799 stack() {
            return this.stack;
        }
    }

    public static final class FluidStackResource
    extends Record
    implements SelectableResource<FluidStack> {
        private final FluidStack stack;

        public FluidStackResource(FluidStack stack) {
            this.stack = stack;
        }

        @Override
        public long getCount() {
            return this.stack().getAmount();
        }

        @Override
        public void setCount(int count) {
            this.stack.setAmount((long)count);
        }

        @Override
        public class_2561 getName() {
            return this.stack.getName();
        }

        @Override
        public Icon getIcon() {
            return Icon.getIcon(ClientUtils.getStillTexture(this.stack)).withTint(Color4I.rgb(ClientUtils.getFluidColor(this.stack)));
        }

        @Override
        public SelectableResource<FluidStack> copyWithCount(long count) {
            return SelectableResource.fluid(this.stack.copyWithAmount(count));
        }

        @Override
        public class_2487 getComponentsTag() {
            class_2487 t;
            class_2520 tag = (class_2520)class_9323.field_50234.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.stack.getComponents()).result().orElse(new class_2487());
            return tag instanceof class_2487 ? (t = (class_2487)tag) : null;
        }

        @Override
        public void applyComponentsTag(class_2487 tag) {
            class_9323.field_50234.parse((DynamicOps)class_2509.field_11560, (Object)tag).result().ifPresent(arg_0 -> ((FluidStack)this.stack).applyComponents(arg_0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FluidStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FluidStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FluidStackResource.class, "stack", "stack"}, this, o);
        }

        @Override
        public FluidStack stack() {
            return this.stack;
        }
    }

    public static class ImageResource
    implements SelectableResource<class_2960> {
        private final class_2960 location;
        private final class_2561 name;
        private final Icon icon;

        public ImageResource(class_2960 location) {
            this.location = location;
            this.name = location == null ? class_2561.method_43471((String)"gui.none").method_27692(class_124.field_1080) : class_2561.method_43470((String)location.method_12836()).method_27692(class_124.field_1065).method_27693(":").method_10852((class_2561)class_2561.method_43470((String)location.method_12832()).method_27692(class_124.field_1054));
            this.icon = Icon.getIcon(location);
        }

        @Override
        public class_2960 stack() {
            return this.location;
        }

        @Override
        public long getCount() {
            return 1L;
        }

        @Override
        public void setCount(int count) {
        }

        @Override
        public class_2561 getName() {
            return this.name;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public SelectableResource<class_2960> copyWithCount(long count) {
            return this;
        }

        @Override
        public class_2487 getComponentsTag() {
            return null;
        }

        @Override
        public void applyComponentsTag(class_2487 tag) {
        }
    }
}

