/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.api.sidebar.ButtonOverlayRender;
import dev.ftb.mods.ftblibrary.api.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonData;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.misc.LoadingScreen;
import dev.ftb.mods.ftblibrary.util.ChainedBooleanSupplier;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class RegisteredSidebarButton
implements SidebarButton {
    private final SidebarButtonData data;
    private final class_2960 id;
    private final String langKey;
    private final class_2561 tooltip;
    private final List<ButtonOverlayRender> extraRenderers;
    private Supplier<List<class_2561>> tooltipOverride;
    private ChainedBooleanSupplier visible = ChainedBooleanSupplier.TRUE;
    private boolean forceHidden = false;

    public RegisteredSidebarButton(class_2960 id, SidebarButtonData data) {
        this.id = id;
        this.data = data;
        this.langKey = class_156.method_646((String)"sidebar_button", (class_2960)id);
        this.tooltip = class_2561.method_43471((String)(this.langKey + ".tooltip"));
        if (data.requiresOp()) {
            this.addVisibilityCondition(ClientUtils.IS_CLIENT_OP);
        }
        data.requiredMods().ifPresent(mods -> this.addVisibilityCondition(() -> mods.stream().allMatch(Platform::isModLoaded)));
        this.extraRenderers = new ArrayList<ButtonOverlayRender>();
        if (!data.envCondition().isEmpty()) {
            if (data.envCondition().startsWith("!")) {
                this.addVisibilityCondition(() -> !System.getenv().containsKey(data.envCondition().substring(1)));
            } else {
                this.addVisibilityCondition(() -> System.getenv().containsKey(data.envCondition()));
            }
        }
    }

    public SidebarButtonData getData() {
        return this.data;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public List<class_2561> getTooltip(boolean shift) {
        if (this.tooltipOverride != null) {
            return this.tooltipOverride.get();
        }
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        tooltips.add((class_2561)class_2561.method_43471((String)this.langKey));
        if (shift) {
            tooltips.add(this.tooltip);
        }
        Optional<List<class_2561>> components = shift ? this.data.shiftTooltip() : this.data.tooltip();
        components.ifPresent(tooltips::addAll);
        return tooltips;
    }

    public void clickButton(boolean shift) {
        if (this.data.loadingScreen()) {
            new LoadingScreen((class_2561)class_2561.method_43471((String)this.getLangKey())).openGui();
        }
        boolean canShift = shift && this.data.shiftClickEvent().isPresent();
        List<String> clickEvents = canShift ? this.data.shiftClickEvent().get() : this.data.clickEvents();
        for (String event : clickEvents) {
            GuiHelper.BLANK_GUI.handleClick(event);
        }
    }

    public boolean canSee() {
        return !this.forceHidden && this.visible.getAsBoolean();
    }

    public void setForceHidden(boolean forceHidden) {
        this.forceHidden = forceHidden;
    }

    @Override
    public void addVisibilityCondition(BooleanSupplier condition) {
        this.visible = this.visible.and(condition);
    }

    @Override
    public void addOverlayRender(ButtonOverlayRender renderer) {
        this.extraRenderers.add(renderer);
    }

    @Override
    public void setTooltipOverride(Supplier<List<class_2561>> tooltipOverride) {
        this.tooltipOverride = tooltipOverride;
    }

    public List<ButtonOverlayRender> getExtraRenderers() {
        return this.extraRenderers;
    }
}

