/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_7919;
import net.minecraft.class_8001;

public class MenuScreenWrapper<T extends class_1703>
extends class_465<T>
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private final TooltipList tooltipList = new TooltipList();
    private boolean drawSlots = true;

    public MenuScreenWrapper(BaseScreen g, T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.wrappedGui = g;
    }

    public MenuScreenWrapper<T> disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void method_25426() {
        super.method_25426();
        this.wrappedGui.initGui();
        this.field_2776 = this.wrappedGui.getX();
        this.field_2800 = this.wrappedGui.getY();
        this.field_2792 = this.wrappedGui.width;
        this.field_2779 = this.wrappedGui.height;
    }

    public boolean method_25421() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean method_25402(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        return this.wrappedGui.mousePressed(MouseButton.get(button)) || super.method_25402(x, y, button);
    }

    public boolean method_25406(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.method_25406(x, y, button);
    }

    public boolean method_25401(double x, double y, double dirX, double dirY) {
        return this.wrappedGui.mouseScrolled(dirY) || super.method_25401(x, y, dirX, dirY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
            return true;
        }
        if (this.wrappedGui.onClosedByKey(key)) {
            if (this.method_25422()) {
                this.wrappedGui.closeGui(false);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.method_25400(keyChar, (int)keyChar);
    }

    protected void method_2389(class_332 graphics, float f, int mx, int my) {
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.method_25420(graphics, mx, my, f);
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(graphics, theme, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (class_1735 slot : this.field_2797.field_7761) {
                theme.drawContainerSlot(graphics, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872, 16, 16);
            }
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)(-this.field_2776), (float)(-this.field_2800), 0.0f);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(graphics, theme, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        this.wrappedGui.addMouseOverText(this.tooltipList);
        int zLevel = this.wrappedGui.getMaxZLevel() + 100;
        graphics.method_51448().method_22903();
        if (!this.tooltipList.shouldRender()) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> {
                class_1799 stack;
                Object ingredient;
                if (underMouse.tooltip() && (ingredient = underMouse.ingredient()) instanceof class_1799 && !(stack = (class_1799)ingredient).method_7960()) {
                    graphics.method_51448().method_46416(0.0f, 0.0f, (float)zLevel);
                    graphics.method_51446(theme.getFont(), (class_1799)ingredient, mouseX, mouseY);
                }
            });
        } else {
            List lines = class_7919.method_47406((class_310)this.field_22787, (class_2561)((class_2561)this.tooltipList.getLines().stream().reduce((c1, c2) -> c1.method_27661().method_27693("\n").method_10852(c2)).orElse(class_2561.method_43473())));
            graphics.method_51448().method_46416(0.0f, 0.0f, (float)zLevel);
            graphics.method_51422(1.0f, 1.0f, 1.0f, 0.8f);
            graphics.method_51436(theme.getFont(), lines, class_8001.field_41687, mouseX, Math.max(mouseY, 18));
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        graphics.method_51448().method_22909();
        this.tooltipList.reset();
        graphics.method_51448().method_22909();
    }

    public void method_25420(class_332 graphics, int x, int y, float partialTicks) {
        if (this.wrappedGui.drawDefaultBackground(graphics)) {
            super.method_25420(graphics, x, y, partialTicks);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_37432() {
        super.method_37432();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void method_25432() {
        this.wrappedGui.onClosed();
        super.method_25432();
    }
}

