/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.modconfig.CoroConfigRegistry;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.watut.PlayerStatusManagerClient;
import com.corosus.watut.PlayerStatusManagerServer;
import com.corosus.watut.config.ConfigClient;
import com.corosus.watut.config.ConfigCommon;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.config.CustomArmCorrections;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2960;
import net.minecraft.class_3324;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class WatutMod {
    public static final String MODID = "watut";
    private static PlayerStatusManagerClient playerStatusManagerClient = null;
    private static PlayerStatusManagerServer playerStatusManagerServer = null;
    public static String configJSONName = "watut-item-arm-adjustments.json";
    private static WatutMod instance;

    public static WatutMod instance() {
        return instance;
    }

    public static PlayerStatusManagerClient getPlayerStatusManagerClient() {
        if (playerStatusManagerClient == null) {
            playerStatusManagerClient = new PlayerStatusManagerClient();
        }
        return playerStatusManagerClient;
    }

    public static PlayerStatusManagerServer getPlayerStatusManagerServer() {
        if (playerStatusManagerServer == null) {
            playerStatusManagerServer = new PlayerStatusManagerServer();
        }
        return playerStatusManagerServer;
    }

    public WatutMod() {
        instance = this;
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ConfigCommon());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ConfigServerControlledSyncedToClient());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ConfigClient());
        WatutMod.generateJsonConfigFile(configJSONName);
        CustomArmCorrections.loadJsonConfigs();
    }

    public static void generateJsonConfigFile(String filename) {
        File fileOut;
        String filePath = "config/" + filename;
        String fileContents = WatutMod.getContentsFromResourceLocation(class_2960.method_60655((String)MODID, (String)filePath));
        if (!fileContents.equals("") && !(fileOut = new File("./config/" + filename)).exists()) {
            try {
                FileUtils.writeStringToFile((File)fileOut, (String)fileContents, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String getContentsFromResourceLocation(class_2960 resourceLocation) {
        try {
            String str = "assets/" + resourceLocation.toString().replace(":", "/");
            InputStream in = WatutMod.class.getClassLoader().getResourceAsStream(str);
            String contents = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return contents;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void loadConfigs() {
    }

    public abstract class_3324 getPlayerList();

    public static void dbg(Object obj) {
    }

    public abstract boolean isModInstalled(String var1);

    public abstract float getFarPlane();
}

