/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.config.CommonConfiguration;
import com.lootintegrations.loot.INoMapContext;
import com.lootintegrations.loot.LootModifierManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class GlobalLootModifierIntegration {
    private final class_2960 location;
    public class_2960 lootTableId;
    public Map<class_2960, Integer> integratedTables = new HashMap<class_2960, Integer>();
    private int fillSize = 27;
    private static final Set<class_2960> inbuiltTables = Set.of(LootintegrationsMod.resFor("chests/easy"), LootintegrationsMod.resFor("chests/medium"), LootintegrationsMod.resFor("chests/hard"), LootintegrationsMod.resFor("chests/nether"), LootintegrationsMod.resFor("chests/water"), LootintegrationsMod.resFor("chests/village"), LootintegrationsMod.resFor("chests/empty"));
    private static final String LOOT_TABLE_ID = "loot_table";
    private static final String INTEGRATED_LOOT_TABLES = "integrated_loot_tables";
    private static final String MAX_RESULT_ITEMCOUNT = "max_result_itemcount";

    private GlobalLootModifierIntegration(class_2960 location) {
        this.location = location;
    }

    public void doApply(List<class_1799> generatedLoot, class_47 context, class_52 lootTable) {
        int weight;
        int i;
        Object extraItems = new ArrayList();
        try {
            class_47 generatingContext = new class_47.class_48(context.field_44881).method_309(Optional.empty());
            if (context instanceof INoMapContext) {
                INoMapContext noMapContext = (INoMapContext)context;
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipMapItems) {
                    noMapContext.disabledMaps();
                }
            }
            extraItems = ((class_52)((class_2378)context.method_299().method_8503().method_58576().method_58289().method_33310(class_7924.field_50079).get()).method_10223(this.lootTableId)).method_319(generatingContext);
        }
        catch (Exception e) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.warn("Loot generation of modifier:" + String.valueOf(this.location) + " for context failed for:" + String.valueOf(this.lootTableId), (Throwable)e);
            }
            return;
        }
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput && !inbuiltTables.contains(this.lootTableId)) {
            LootintegrationsMod.LOGGER.info("Adding loot to: " + String.valueOf(LootintegrationsMod.getLootTableId(lootTable, context.method_299().method_8503())) + " from: " + String.valueOf(this.lootTableId) + " caused by:" + String.valueOf(this.location));
        }
        if (extraItems.isEmpty()) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.info("Could not generate items for loottable: " + String.valueOf(this.lootTableId));
            }
            return;
        }
        int itemCount = this.integratedTables.getOrDefault(LootintegrationsMod.getLootTableId(lootTable, context.method_299().method_8503()), 1);
        if ((extraItems = this.aggregateStacks((List<class_1799>)extraItems, false)).isEmpty()) {
            return;
        }
        if (!generatedLoot.isEmpty() && generatedLoot.size() + itemCount > this.fillSize) {
            List<class_1799> newList = this.aggregateStacks(generatedLoot, true);
            generatedLoot.clear();
            generatedLoot.addAll(newList);
            if (generatedLoot.size() > this.fillSize) {
                int size = Math.min(generatedLoot.size(), generatedLoot.size() + itemCount - this.fillSize);
                for (int i2 = 0; i2 < size; ++i2) {
                    generatedLoot.remove(LootintegrationsMod.rand.nextInt(generatedLoot.size()));
                }
            }
        }
        if (itemCount == 0) {
            return;
        }
        int[] weights = new int[extraItems.size()];
        int totalWeight = 0;
        int size = extraItems.size();
        for (i = 0; i < size; ++i) {
            weight = this.calcWeightForStack((class_1799)extraItems.get(i));
            weights[i] = totalWeight += weight;
        }
        for (i = 0; i < itemCount; ++i) {
            if (totalWeight <= 0) {
                return;
            }
            weight = LootintegrationsMod.rand.nextInt(totalWeight);
            int index = -1;
            int removedWeight = 0;
            class_1799 stack = null;
            for (int j = 0; j < size; ++j) {
                if (index == -1 && weight < weights[j]) {
                    index = j;
                    weights[j] = 0;
                    stack = (class_1799)extraItems.get(index);
                    removedWeight = this.calcWeightForStack(stack);
                    totalWeight -= removedWeight;
                    continue;
                }
                if (index == -1) continue;
                int n = j;
                weights[n] = weights[n] - removedWeight;
            }
            if (stack == null) continue;
            boolean sameItem = false;
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipExistingItems) {
                for (int j = 0; j < generatedLoot.size(); ++j) {
                    if (!class_1799.method_31577((class_1799)generatedLoot.get(j), (class_1799)stack)) continue;
                    sameItem = true;
                    break;
                }
            }
            if (!sameItem) {
                generatedLoot.add(stack);
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                    LootintegrationsMod.LOGGER.info("Adding loot to: " + String.valueOf(LootintegrationsMod.getLootTableId(lootTable, context.method_299().method_8503())) + " item:" + stack.toString());
                }
            } else {
                --i;
            }
            if (extraItems.isEmpty()) break;
        }
    }

    private int calcWeightForStack(class_1799 stack) {
        return ((class_5321)stack.method_41409().method_40230().get()).method_29177().method_12836().equals("minecraft") ? 1 : ((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).moddedItemWeight + 1;
    }

    private List<class_1799> aggregateStacks(List<class_1799> stacksIn, boolean originalLoot) {
        HashMap<class_1792, class_1799> aggregated = new HashMap<class_1792, class_1799>();
        for (class_1799 stack : stacksIn) {
            class_1799 contained = (class_1799)aggregated.get(stack.method_7909());
            if (stack.method_7960() || !originalLoot && stack.method_31573(LootModifierManager.IGNORED_FOR_LOOT)) continue;
            if (contained == null) {
                aggregated.put(stack.method_7909(), stack);
                continue;
            }
            if (!class_1799.method_31577((class_1799)stack, (class_1799)contained)) continue;
            contained.method_7939(Math.min(contained.method_7947() + stack.method_7947(), Math.max(1, contained.method_7914() / 2)));
        }
        return new ArrayList<class_1799>(aggregated.values());
    }

    public static GlobalLootModifierIntegration read(class_2960 location, JsonElement data) {
        GlobalLootModifierIntegration modifier = new GlobalLootModifierIntegration(location);
        JsonObject jsonData = (JsonObject)data;
        modifier.lootTableId = class_2960.method_12829((String)jsonData.get(LOOT_TABLE_ID).getAsString());
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput && location.method_12832().contains("lootintegrations_")) {
            LootintegrationsMod.LOGGER.info("Parsing loot modifiers for:" + String.valueOf(location) + " with loottable: " + String.valueOf(modifier.lootTableId));
        }
        if (jsonData.has(MAX_RESULT_ITEMCOUNT)) {
            modifier.fillSize = jsonData.get(MAX_RESULT_ITEMCOUNT).getAsInt();
        }
        HashMap<class_2960, Integer> integratedTables = new HashMap<class_2960, Integer>();
        for (Map.Entry element : jsonData.get(INTEGRATED_LOOT_TABLES).getAsJsonObject().entrySet()) {
            class_2960 integratedTable = class_2960.method_12829((String)((String)element.getKey()));
            integratedTables.put(integratedTable, ((JsonElement)element.getValue()).getAsInt());
        }
        modifier.integratedTables = integratedTables;
        return modifier;
    }
}

