/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.entity;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.paladins.PaladinsMod;
import net.paladins.config.TweaksConfig;
import net.paladins.content.PaladinSounds;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.entity.SpellEntity;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.target.EntityRelation;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.utils.SoundPlayerWorld;
import org.jetbrains.annotations.Nullable;

public class BarrierEntity
extends class_1297
implements SpellEntity.Spawned {
    public static class_1299<BarrierEntity> TYPE;
    private class_2960 spellId;
    private int ownerId;
    private int timeToLive = 20;
    private static final class_2940<String> SPELL_ID_TRACKER;
    private static final class_2940<Integer> OWNER_ID_TRACKER;
    private static final class_2940<Integer> TIME_TO_LIVE_TRACKER;
    private boolean idleSoundFired = false;
    private static final int checkInterval = 4;
    private class_1309 cachedOwner = null;

    public BarrierEntity(class_1299<? extends BarrierEntity> entityType, class_1937 world) {
        super(entityType, world);
        ((TwoWayCollisionChecker)this).setReverseCollisionChecker(entity -> this.method_30949((class_1297)entity) ? TwoWayCollisionChecker.CollisionResult.COLLIDE : TwoWayCollisionChecker.CollisionResult.PASS);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void onSpawnedBySpell(SpellEntity.Spawned.Args args) {
        class_1309 owner = args.owner();
        class_2960 spellId = ((class_5321)args.spell().method_40230().get()).method_29177();
        Spell.Impact.Action.Spawn spawn = args.spawnData();
        this.spellId = spellId;
        this.method_5841().method_12778(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.ownerId = owner.method_5628();
        this.method_5841().method_12778(OWNER_ID_TRACKER, (Object)this.ownerId);
        this.timeToLive = spawn.time_to_live_seconds * 20;
        this.method_5841().method_12778(TIME_TO_LIVE_TRACKER, (Object)this.timeToLive);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_49108() {
        return this.method_5805();
    }

    public boolean method_30949(class_1297 other) {
        class_1309 owner = this.getOwner();
        if (owner == null) {
            return super.method_30949(other);
        }
        if (other instanceof class_1309) {
            class_1309 otherLiving = (class_1309)other;
            return !this.isProtected((class_1297)otherLiving);
        }
        return super.method_30949(other);
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.method_37908().method_43129(null, (class_1297)this, PaladinSounds.holy_barrier_impact.soundEvent(), class_3419.field_15248, 1.0f, 1.0f);
        return super.method_5643(source, amount);
    }

    public class_4048 method_18377(class_4050 pose) {
        class_6880<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry != null) {
            Spell spell = (Spell)spellEntry.comp_349();
            float width = spell.range * 2.0f;
            float height = spell.range;
            return class_4048.method_18384((float)width, (float)height);
        }
        return super.method_18377(pose);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SPELL_ID_TRACKER, (Object)"");
        builder.method_56912(OWNER_ID_TRACKER, (Object)0);
        builder.method_56912(TIME_TO_LIVE_TRACKER, (Object)0);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        String rawSpellId = (String)this.method_5841().method_12789(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = class_2960.method_60654((String)rawSpellId);
        }
        this.timeToLive = (Integer)this.method_5841().method_12789(TIME_TO_LIVE_TRACKER);
        this.method_18382();
    }

    protected void method_5749(class_2487 nbt) {
        this.spellId = class_2960.method_60654((String)nbt.method_10558(NBTKey.SPELL_ID.key));
        this.ownerId = nbt.method_10550(NBTKey.OWNER_ID.key);
        this.timeToLive = nbt.method_10550(NBTKey.TIME_TO_LIVE.key);
        this.method_5841().method_12778(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.method_5841().method_12778(OWNER_ID_TRACKER, (Object)this.ownerId);
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10582(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.method_10569(NBTKey.OWNER_ID.key, this.ownerId);
        nbt.method_10569(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
    }

    public boolean method_5701() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        class_6880<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            if (!this.idleSoundFired) {
                ((SoundPlayerWorld)world).playSoundFromEntity((class_1297)this, PaladinSounds.holy_barrier_idle.soundEvent(), class_3419.field_15248, 1.0f, 1.0f);
                this.idleSoundFired = true;
            }
        } else {
            if (this.field_6012 > this.timeToLive) {
                this.method_5768();
            }
            if (this.field_6012 % 4 == 0) {
                List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014((double)0.1f));
                for (class_1297 entity : entities) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 livingEntity = (class_1309)entity;
                    if (this.isProtected((class_1297)livingEntity)) {
                        EntityImmunity.setImmune((class_1297)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.AREA_EFFECT, (int)5);
                        EntityImmunity.setImmune((class_1297)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.EXPLOSION, (int)5);
                        continue;
                    }
                    livingEntity.method_6005((double)((TweaksConfig)PaladinsMod.tweaksConfig.value).barrier_knockback_strength, this.method_23317() - livingEntity.method_23317(), this.method_23321() - livingEntity.method_23321());
                    if (!(livingEntity instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)livingEntity;
                    serverPlayer.field_13987.method_52391((class_2596)new class_2743(serverPlayer.method_5628(), serverPlayer.method_18798()), null);
                }
            }
            if (this.field_6012 == this.timeToLive - this.expirationDuration()) {
                this.method_37908().method_43129(null, (class_1297)this, PaladinSounds.holy_barrier_deactivate.soundEvent(), class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public int expirationDuration() {
        return 20;
    }

    public boolean isExpiring() {
        return this.field_6012 >= this.timeToLive - this.expirationDuration();
    }

    public boolean isProtected(class_1297 other) {
        class_1309 owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        EntityRelation relation = EntityRelations.getRelation((class_1309)owner, (class_1297)other);
        switch (relation) {
            case ALLY: 
            case FRIENDLY: {
                return true;
            }
            case NEUTRAL: 
            case MIXED: 
            case HOSTILE: {
                return false;
            }
        }
        return false;
    }

    @Nullable
    public class_6880<Spell> getSpellEntry() {
        return SpellRegistry.from((class_1937)this.method_37908()).method_55841(this.spellId).orElse(null);
    }

    @Nullable
    public class_1309 getOwner() {
        if (this.cachedOwner != null) {
            return this.cachedOwner;
        }
        class_1297 owner = this.method_37908().method_8469(this.ownerId);
        if (owner instanceof class_1309) {
            class_1309 livingOwner;
            this.cachedOwner = livingOwner = (class_1309)owner;
            return livingOwner;
        }
        return null;
    }

    static {
        SPELL_ID_TRACKER = class_2945.method_12791(BarrierEntity.class, (class_2941)class_2943.field_13326);
        OWNER_ID_TRACKER = class_2945.method_12791(BarrierEntity.class, (class_2941)class_2943.field_13327);
        TIME_TO_LIVE_TRACKER = class_2945.method_12791(BarrierEntity.class, (class_2941)class_2943.field_13327);
    }

    private static enum NBTKey {
        OWNER_ID("OwnerId"),
        SPELL_ID("SpellId"),
        TIME_TO_LIVE("TTL");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

