/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.advancedreborn.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.pitan76.advancedreborn.Tiles;
import net.pitan76.advancedreborn.addons.autoconfig.AutoConfigAddon;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import org.jetbrains.annotations.Nullable;
import techreborn.blockentity.storage.energy.EnergyStorageBlockEntity;

public class TeleporterTile
extends class_2586
implements class_5558<TeleporterTile> {
    private static final class_265 SHAPE_RANGE = class_259.method_1081((double)-2.0, (double)-2.0, (double)-2.0, (double)3.0, (double)3.0, (double)3.0);
    private class_2338 teleportPos = null;

    public TeleporterTile(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TeleporterTile(class_2338 pos, class_2680 state) {
        this((class_2591)Tiles.TELEPORTER_TILE.getOrNull(), pos, state);
    }

    public TeleporterTile(TileCreateEvent event) {
        this(event.getBlockPos(), event.getBlockState());
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, TeleporterTile tile) {
        Iterator<class_1297> iterator;
        if (!AutoConfigAddon.getConfig().teleporterEnabled) {
            return;
        }
        if (world == null) {
            return;
        }
        if (WorldUtil.isClient((class_1937)world)) {
            return;
        }
        if (this.getTeleportPos() == null) {
            return;
        }
        List<class_1297> entities = this.getEntities();
        if (entities.isEmpty()) {
            return;
        }
        if (!world.method_49803(this.method_11016())) {
            return;
        }
        if (this.use() && (iterator = entities.iterator()).hasNext()) {
            class_1297 entity = iterator.next();
            entity.method_5859((double)this.getTeleportPos().method_10263() - 0.5, (double)this.getTeleportPos().method_10264() - 0.5, (double)this.getTeleportPos().method_10260() - 0.5);
            return;
        }
    }

    public boolean useTile(class_2586 blockEntity) {
        EnergyStorageBlockEntity energyStorage;
        if (blockEntity instanceof EnergyStorageBlockEntity && (energyStorage = (EnergyStorageBlockEntity)blockEntity).getEnergy() >= (long)AutoConfigAddon.getConfig().teleporterUseEnergy) {
            energyStorage.useEnergy((long)AutoConfigAddon.getConfig().teleporterUseEnergy);
            return true;
        }
        return false;
    }

    public boolean use() {
        if (this.field_11863 == null) {
            return false;
        }
        class_2586 up = WorldUtil.getBlockEntity((class_1937)this.field_11863, (class_2338)this.field_11867.method_10084());
        class_2586 down = WorldUtil.getBlockEntity((class_1937)this.field_11863, (class_2338)this.field_11867.method_10074());
        class_2586 north = WorldUtil.getBlockEntity((class_1937)this.field_11863, (class_2338)this.field_11867.method_10095());
        class_2586 south = WorldUtil.getBlockEntity((class_1937)this.field_11863, (class_2338)this.field_11867.method_10072());
        class_2586 east = WorldUtil.getBlockEntity((class_1937)this.field_11863, (class_2338)this.field_11867.method_10078());
        class_2586 west = WorldUtil.getBlockEntity((class_1937)this.field_11863, (class_2338)this.field_11867.method_10067());
        if (this.useTile(up)) {
            return true;
        }
        if (this.useTile(down)) {
            return true;
        }
        if (this.useTile(north)) {
            return true;
        }
        if (this.useTile(south)) {
            return true;
        }
        if (this.useTile(east)) {
            return true;
        }
        return this.useTile(west);
    }

    @Nullable
    public class_2338 getTeleportPos() {
        return this.teleportPos;
    }

    @Nullable
    public void setTeleportPos(class_2338 teleportPos) {
        this.teleportPos = teleportPos;
    }

    public List<class_1297> getEntities() {
        try {
            return SHAPE_RANGE.method_1090().stream().flatMap(box -> WorldUtil.getEntitiesByClass((class_1937)this.method_10997(), class_1297.class, (class_238)box.method_989(this.getX(), this.getY(), this.getZ()), (Predicate)class_1301.field_6154).stream()).collect(Collectors.toList());
        }
        catch (NullPointerException e) {
            return new ArrayList<class_1297>();
        }
    }

    public double getX() {
        return this.method_11016().method_10263();
    }

    public double getY() {
        return this.method_11016().method_10264();
    }

    public double getZ() {
        return this.method_11016().method_10260();
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.getTeleportPos() != null) {
            nbt.method_10549("tpX", (double)this.getTeleportPos().method_10263());
            nbt.method_10549("tpY", (double)this.getTeleportPos().method_10264());
            nbt.method_10549("tpZ", (double)this.getTeleportPos().method_10260());
        }
        super.method_11007(nbt, registryLookup);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11014(tag, registryLookup);
        if (tag.method_10545("tpX") && tag.method_10545("tpY") && tag.method_10545("tpZ")) {
            this.teleportPos = PosUtil.flooredBlockPos((double)tag.method_10574("tpX"), (double)tag.method_10574("tpY"), (double)tag.method_10574("tpZ"));
        }
    }
}

