/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_8002;

public final class TooltipRenderHelper {
    private TooltipRenderHelper() {
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack, class_1836 tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        class_310 minecraft = class_310.method_1551();
        return itemStack.method_7950(class_1792.class_9635.method_59528((class_1937)minecraft.field_1687), (class_1657)minecraft.field_1724, tooltipFlag);
    }

    public static List<class_5684> getTooltip(class_1799 itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_5684> getTooltip(class_1799 itemStack, class_1836 tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<class_2561> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<class_5632> imageComponents = itemStack.method_32347().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, class_1799 itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, class_2561 component, class_5632 imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components, class_5632 imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components) {
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of());
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components, List<class_5632> imageComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<class_5684> createClientComponents(List<class_2561> components, List<class_5632> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<class_5684> createClientComponents(List<class_2561> components, List<class_5632> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        List<class_5684> clientImageComponents = imageComponents.stream().map(ClientAbstractions.INSTANCE::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(Math.min(clientComponents.size(), insertAt), clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    public static void renderTooltipComponents(class_332 guiGraphics, int posX, int posY, List<? extends class_5684> components) {
        int i;
        if (components.isEmpty()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        boolean result = ClientAbstractions.INSTANCE.onRenderTooltip(guiGraphics, minecraft.field_1772, posX, posY, components, class_8001.field_41687);
        if (result) {
            return;
        }
        int lineWidth = 0;
        int lineHeight = components.size() == 1 ? -2 : 0;
        for (class_5684 component : components) {
            int width = component.method_32664(minecraft.field_1772);
            if (width > lineWidth) {
                lineWidth = width;
            }
            lineHeight += component.method_32661();
        }
        guiGraphics.method_51448().method_22903();
        TooltipRenderHelper.renderTooltipBackground(guiGraphics, posX += 12, posY -= 12, lineWidth, lineHeight);
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        int currentPosY = posY;
        for (i = 0; i < components.size(); ++i) {
            class_5684 component = components.get(i);
            component.method_32665(minecraft.field_1772, posX, currentPosY, guiGraphics.method_51448().method_23760().method_23761(), guiGraphics.method_51450());
            currentPosY += component.method_32661() + (i == 0 ? 2 : 0);
        }
        currentPosY = posY;
        for (i = 0; i < components.size(); ++i) {
            class_5684 component = components.get(i);
            component.method_32666(minecraft.field_1772, posX, currentPosY, guiGraphics);
            currentPosY += component.method_32661() + (i == 0 ? 2 : 0);
        }
        guiGraphics.method_51452();
        guiGraphics.method_51448().method_22909();
    }

    private static void renderTooltipBackground(class_332 guiGraphics, int posX, int posY, int lineWidth, int lineHeight) {
        guiGraphics.method_51741(() -> class_8002.method_47946((class_332)guiGraphics, (int)posX, (int)posY, (int)lineWidth, (int)lineHeight, (int)400));
    }
}

