/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix.gui;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.Global;
import b100.fullscreenfix.VideoMode;
import b100.fullscreenfix.gui.ScreenResolutionsMenu;
import b100.fullscreenfix.mixin.access.IScreen;
import b100.gui.GuiButton;
import b100.gui.GuiContainer;
import b100.gui.GuiElement;
import b100.gui.GuiScrollListScreen;
import b100.gui.config.BooleanToggleElement;
import b100.gui.config.ConfigElement;
import b100.gui.config.CustomOptionElement;
import b100.gui.config.SaveConfigButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends GuiScrollListScreen {
    public GuiButton cancelButton;
    public SaveConfigButton saveConfigButton;
    private CustomOptionElement<VideoMode> fullscreenResolutionButton;

    public ConfigScreen(IScreen parentScreen) {
        super(parentScreen);
        this.title = FullscreenFix.translate("screen.fullscreenSettings.title");
    }

    @Override
    public void onInit() {
        this.saveConfigButton = new SaveConfigButton(this);
        this.saveConfigButton.addActionListener(e -> {
            FullscreenFix.saveConfig();
            this.back();
        });
        super.onInit();
        this.cancelButton = this.add(new GuiButton(this, FullscreenFix.translate("button.cancel")).addActionListener(e -> this.back()));
        this.add(this.saveConfigButton);
    }

    @Override
    public void initScrollElements() {
        this.scrollList.add(new BooleanToggleElement(this, "option.enableMod", FullscreenFix.isModEnabledNextLaunch()).addSaveConsumer(newValue -> FullscreenFix.setModEnabled(newValue)));
        if (Global.MOD_ENABLED) {
            this.scrollList.add(new BooleanToggleElement(this, "option.fullscreen", FullscreenFix.isFullscreenEnabled()).addSaveConsumer(newValue -> FullscreenFix.setFullscreen(newValue)));
            this.scrollList.add(new BooleanToggleElement(this, "option.borderlessFullscreen", FullscreenFix.isBorderlessEnabled()).addSaveConsumer(newValue -> FullscreenFix.setBorderless(newValue)));
            if (Global.OS_WINDOWS) {
                this.scrollList.add(new BooleanToggleElement(this, "option.windowsFullscreenOptimizations", FullscreenFix.isWindowsFullscreenOptimizationsEnabled()).addSaveConsumer(newValue -> FullscreenFix.setWindowsFullscreenOptimizations(newValue)));
            }
            this.scrollList.add(new BooleanToggleElement(this, "option.autoMinimize", FullscreenFix.isAutoMinimizeEnabled()).addSaveConsumer(newValue -> FullscreenFix.setAutoMinimize(newValue)));
            this.scrollList.add(new BooleanToggleElement(this, "option.startInFullscreen", FullscreenFix.isStartInFullscreenEnabled()).addSaveConsumer(newValue -> FullscreenFix.setStartInFullscreen(newValue)));
            this.fullscreenResolutionButton = this.scrollList.add(new CustomOptionElement<VideoMode>(this, "option.fullscreenResolution", FullscreenFix.getFullscreenVideoMode()).addActionListener(e -> this.utils.setScreen(new ScreenResolutionsMenu(this))).setToTextFunction(videoMode -> videoMode != null ? class_2561.method_30163((String)videoMode.toString()) : FullscreenFix.translate("value.fullscreenResolution.default")));
            this.scrollList.add(new BooleanToggleElement(this, "option.replaceVideoSettings", FullscreenFix.shouldReplaceVideoSettingsButton()).addSaveConsumer(newValue -> FullscreenFix.setReplaceVideoSettingsButton(newValue)));
        }
    }

    @Override
    public void elementAdded(GuiContainer parent, GuiElement element) {
        if (element instanceof ConfigElement) {
            ConfigElement configElement = (ConfigElement)((Object)element);
            configElement.addConfigElementListener(this.saveConfigButton);
        }
        super.elementAdded(parent, element);
    }

    @Override
    public void onResize() {
        this.setDoubleFooterButtonPositions(this.saveConfigButton, this.cancelButton);
        super.onResize();
    }

    @Override
    public void onScreenOpened() {
        if (this.fullscreenResolutionButton != null) {
            this.fullscreenResolutionButton.setValue(FullscreenFix.getFullscreenVideoMode());
        }
        super.onScreenOpened();
    }
}

