/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.gui.GuiContainer;
import b100.gui.GuiUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class GuiElement {
    public GuiUtils utils = GuiUtils.instance;
    public int posX;
    public int posY;
    public int width;
    public int height;
    private GuiContainer container;

    public abstract void draw();

    public boolean keyEvent(int key, int scancode, int modifiers, boolean pressed) {
        return false;
    }

    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        return false;
    }

    public boolean scrollEvent(double horizontalAmount, double verticalAmount, double mouseX, double mouseY) {
        return false;
    }

    public void onResize() {
    }

    public GuiElement setPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    public GuiElement setSize(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public boolean isInside(double x, double y) {
        return x >= (double)this.posX && y >= (double)this.posY && x < (double)(this.posX + this.width) && y < (double)(this.posY + this.height);
    }

    public boolean isSolid() {
        return true;
    }

    public void onAddedToContainer(GuiContainer container) {
        if (this.container != null) {
            throw new RuntimeException("Cannot add element " + String.valueOf(this) + "to container " + String.valueOf(container) + " because element is already added to container " + String.valueOf(this.container) + "!");
        }
        this.container = container;
    }

    public void onRemovedFromContainer(GuiContainer container) {
        this.container = null;
    }

    public GuiContainer getContainer() {
        return this.container;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + "]";
    }
}

