/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.gui.FocusListener;
import b100.gui.Focusable;
import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.ListenerList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class GuiListButton
extends GuiElement
implements Focusable {
    public GuiScreen screen;
    private final ListenerList<FocusListener> focusListeners = new ListenerList(this);
    public int outlineColorFocused = -1;
    public int outlineColor = -8355712;
    public int fillColor = -16777216;
    public class_2561 text;
    private boolean clickable = true;
    private boolean focused = false;

    public GuiListButton(GuiScreen screen) {
        this.screen = screen;
        this.width = 200;
        this.height = 20;
    }

    @Override
    public void draw() {
        int highlight = this.getHighlightColor();
        if (highlight != 0) {
            this.utils.drawRectangle(this.posX, this.posY, this.width, this.height, highlight);
            this.utils.drawRectangle(this.posX + 1, this.posY + 1, this.width - 2, this.height - 2, this.fillColor);
        }
        if (this.text != null) {
            int textWidth = this.utils.textRenderer.method_27525((class_5348)this.text);
            int textX = this.posX + (this.width - textWidth) / 2;
            int textY = this.posY + this.height / 2 - 4;
            this.utils.drawString(this.text, textX, textY, 0xFFFFFF, true);
        }
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (pressed && this.screen.isMouseOver(this) && this.clickable) {
            this.setFocused(true);
            return true;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            this.onFocusChanged();
        }
    }

    public int getHighlightColor() {
        if (this.isFocused()) {
            return this.outlineColorFocused;
        }
        if (this.getContainer().getLastFocusedElement() == this) {
            return this.outlineColor;
        }
        return 0;
    }

    public void onFocusChanged() {
        this.focusListeners.forEach(e -> e.focusChanged(this));
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public ListenerList<FocusListener> getFocusListeners() {
        return this.focusListeners;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + ",text=" + (this.text != null ? this.text.getString() : null) + "]";
    }
}

