/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.mixin.access.IScreen;
import b100.gui.ContainerListener;
import b100.gui.FocusDirection;
import b100.gui.FocusListener;
import b100.gui.Focusable;
import b100.gui.GuiContainer;
import b100.gui.GuiElement;
import b100.gui.ListenerList;
import b100.gui.ScreenListener;
import b100.gui.ScreenWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public abstract class GuiScreen
extends GuiContainer
implements IScreen,
FocusListener,
ContainerListener {
    private boolean initialized = false;
    public double mouseX = -1.0;
    public double mouseY = -1.0;
    public IScreen parentScreen;
    protected Focusable focusedElement;
    public final ListenerList<ScreenListener> screenListeners = new ListenerList(this);
    public final ListenerList<FocusListener> focusListeners = new ListenerList(this);
    private ScreenWrapper wrapper;

    public GuiScreen(IScreen parentScreen) {
        this.parentScreen = parentScreen;
        this.containerListeners.add(this);
    }

    public void setWrapper(ScreenWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public final void init() {
        if (this.initialized) {
            return;
        }
        this.onInit();
        this.initialized = true;
    }

    protected abstract void onInit();

    @Override
    public void onResize() {
        super.onResize();
    }

    @Override
    public boolean keyEvent(int key, int scancode, int modifiers, boolean pressed) {
        FocusDirection focusDirection;
        if (pressed && key == 256) {
            this.close();
            return true;
        }
        if (super.keyEvent(key, scancode, modifiers, pressed)) {
            return true;
        }
        if (pressed && key == 259) {
            this.back();
            return true;
        }
        return pressed && (focusDirection = FocusDirection.get(key, modifiers)) != null && this.focusNextElement(focusDirection);
    }

    public boolean focusNextElement(FocusDirection direction) {
        Focusable next = this.getNextScreenFocusableElement(this.focusedElement, direction);
        if (next != null) {
            FullscreenFix.debugPrint("Focus Element: " + String.valueOf(next));
            next.setFocused(true);
            return true;
        }
        return false;
    }

    public Focusable getNextScreenFocusableElement(Focusable focusedElement, FocusDirection direction) {
        Focusable next;
        if (focusedElement != null) {
            next = Focusable.findNextFocusableElement((GuiElement)((Object)focusedElement), direction);
            if (next == null && direction.isTab()) {
                next = this.getFirstFocusableElement(direction);
            }
        } else {
            next = this.getFirstFocusableElement(direction);
        }
        return next;
    }

    @Override
    public void elementAdded(GuiContainer parent, GuiElement element) {
        if (element instanceof Focusable) {
            Focusable focusable = (Focusable)((Object)element);
            focusable.getFocusListeners().add(this);
        }
        if (element instanceof ScreenListener) {
            ScreenListener screenListener = (ScreenListener)((Object)element);
            this.screenListeners.add(screenListener);
        }
        if (element instanceof FocusListener) {
            FocusListener focusListener = (FocusListener)((Object)element);
            this.focusListeners.add(focusListener);
        }
        if (element instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)element;
            container.elements.forEach(e -> this.elementAdded(container, (GuiElement)e));
            container.containerListeners.add(this);
        }
    }

    @Override
    public void focusChanged(Focusable focusable) {
        if (focusable.isFocused()) {
            if (this.focusedElement != null) {
                this.focusedElement.setFocused(false);
            }
            this.focusedElement = focusable;
        }
        this.focusListeners.forEach(listener -> listener.focusChanged(focusable));
    }

    public GuiElement getMouseOver() {
        return this.getClickElementAt(this.mouseX, this.mouseY);
    }

    public boolean isMouseOver(GuiElement element) {
        return this.getClickElementAt(this.mouseX, this.mouseY) == element;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void back() {
        this.utils.setScreen(this.parentScreen);
    }

    public void close() {
        this.utils.setScreen(null);
    }

    public void onScreenOpened() {
        this.screenListeners.forEach(listener -> listener.onScreenOpened(this));
    }

    public void setTooltip(class_2561 tooltip) {
        this.wrapper.method_47415(tooltip);
    }
}

