/*
 * Decompiled with CFR 0.152.
 */
package b100.gui.config;

import b100.fullscreenfix.FullscreenFix;
import b100.gui.ActionListener;
import b100.gui.GuiButton;
import b100.gui.GuiContainer;
import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.ListenerList;
import b100.gui.ScreenListener;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class CustomOptionElement<E>
extends GuiContainer
implements ActionListener,
ScreenListener {
    protected GuiScreen screen;
    protected class_2561 name;
    protected E value;
    protected GuiButton button;
    protected Function<E, class_2561> toTextFunction;
    protected class_2561 tooltipText;
    private final ListenerList<ActionListener> actionListeners = new ListenerList(this);

    public CustomOptionElement(GuiScreen screen, String key, E value) {
        this.screen = screen;
        this.name = FullscreenFix.translate(key);
        this.value = value;
        String tooltipText = FullscreenFix.translateIfExists(key + ".tooltip");
        if (tooltipText != null) {
            this.tooltipText = class_2561.method_30163((String)tooltipText);
        }
        this.button = this.add(new GuiButton(screen, null).addActionListener(this));
        this.button.setSize(112, 20);
        this.setSize(320, 24);
        this.update();
    }

    @Override
    public void draw() {
        GuiElement mouseOver = this.button.screen.getMouseOver();
        if (mouseOver == this || this.contains(mouseOver) || this.button.isFocused()) {
            this.utils.drawRectangle(this.posX, this.posY, this.width, this.height, 0x20FFFFFF);
            if (this.tooltipText != null) {
                this.screen.setTooltip(this.tooltipText);
            }
        }
        super.draw();
        this.utils.drawString(this.name, this.posX + 8, this.posY + this.height / 2 - 4, 0xFFFFFF, true);
    }

    @Override
    public void actionPerformed(GuiElement source) {
        this.actionListeners.forEach(e -> e.actionPerformed(this));
    }

    @Override
    public void onResize() {
        this.button.setPosition(this.posX + this.width - this.button.width - 2, this.posY + this.height / 2 - this.button.height / 2);
        super.onResize();
    }

    public void update() {
        this.button.text = this.toTextFunction != null ? this.toTextFunction.apply(this.value) : class_2561.method_30163((String)String.valueOf(this.value));
    }

    public CustomOptionElement<E> setValue(E value) {
        this.value = value;
        return this;
    }

    public E getValue() {
        return this.value;
    }

    public CustomOptionElement<E> setTooltipText(class_2561 tooltipText) {
        this.tooltipText = tooltipText;
        return this;
    }

    public class_2561 getTooltipText() {
        return this.tooltipText;
    }

    public CustomOptionElement<E> setToTextFunction(Function<E, class_2561> toTextFunction) {
        this.toTextFunction = toTextFunction;
        this.update();
        return this;
    }

    public Function<E, class_2561> getToTextFunction() {
        return this.toTextFunction;
    }

    public CustomOptionElement<E> addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
        return this;
    }

    public boolean removeActionListener(ActionListener actionListener) {
        return this.actionListeners.remove(actionListener);
    }

    @Override
    public void onScreenOpened(GuiScreen screen) {
        this.update();
    }

    @Override
    public boolean isSolid() {
        return true;
    }
}

