/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanksOld;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.components.StarterUpgrades;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.item.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.item.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_9282;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BackpackWrapper {
    public static final BackpackWrapper DUMMY = new BackpackWrapper(ModItems.STANDARD_TRAVELERS_BACKPACK.method_7854(), 3, null, null, null);
    protected class_1799 stack;
    public final ItemStackHandler inventory;
    public final ItemStackHandler upgrades;
    public final ItemStackHandler tools;
    public ItemStackHandler upgradesTracker;
    private final UpgradeManager upgradeManager;
    private class_1657 owner;
    public ArrayList<class_1657> playersUsing = new ArrayList();
    protected class_7225.class_7874 registriesAccess;
    protected class_1937 level;
    private final int screenID;
    private long tanksCapacity = 0L;
    public int index = -1;
    public int[] dataLoad = new int[]{1, 1, 1};
    public Runnable saveHandler = () -> {};
    public Runnable abilityHandler = () -> {};
    public class_2338 backpackPos;
    public static final int STORAGE_ID = 0;
    public static final int UPGRADES_ID = 1;
    public static final int TOOLS_ID = 2;

    public BackpackWrapper(class_1799 stack, int screenID, class_7225.class_7874 registriesAccess, @Nullable class_1657 player, @Nullable class_1937 level, int index) {
        this(stack, screenID, registriesAccess, player, level);
        this.index = index;
    }

    public BackpackWrapper(class_1799 stack, int screenID, class_7225.class_7874 registriesAccess, @Nullable class_1657 player, @Nullable class_1937 level) {
        this(stack, screenID, registriesAccess, player, level, new int[]{1, 1, 1});
    }

    public BackpackWrapper(class_1799 stack, int screenID, class_7225.class_7874 registriesAccess, @Nullable class_1657 player, @Nullable class_1937 level, int[] dataLoad) {
        StarterUpgrades upgrades;
        if (player != null) {
            this.playersUsing.add(player);
        }
        if (screenID == 2) {
            this.setBackpackOwner(player);
        }
        this.stack = stack;
        if (!BackpackWrapper.isSizeInitialized(stack)) {
            BackpackWrapper.initializeSize(stack);
        }
        int storageSlots = (Integer)stack.method_57824(ModDataComponents.STORAGE_SLOTS);
        int upgradeSlots = (Integer)stack.method_57824(ModDataComponents.UPGRADE_SLOTS);
        int toolSlots = (Integer)stack.method_57824(ModDataComponents.TOOL_SLOTS);
        this.screenID = screenID;
        this.registriesAccess = registriesAccess;
        this.level = level;
        this.dataLoad = dataLoad;
        this.inventory = this.createHandler(storageSlots, 0);
        this.upgrades = this.createUpgradeHandler(upgradeSlots, 1);
        this.tools = this.createHandler(toolSlots, 2);
        this.upgradesTracker = new ItemStackHandler(this.upgrades.getSlots());
        if (registriesAccess != null) {
            this.loadHandlers();
        }
        this.setBackpackTankCapacity();
        this.upgradeManager = new UpgradeManager(this);
        if (!this.stack.method_57826(ModDataComponents.RENDER_INFO)) {
            this.setRenderInfo(RenderInfo.EMPTY.compoundTag());
        }
        if (stack.method_57826(ModDataComponents.STARTER_UPGRADES) && (upgrades = (StarterUpgrades)stack.method_57824(ModDataComponents.STARTER_UPGRADES)) != null) {
            upgrades.upgrades().forEach(this::setStarterUpgrade);
            stack.method_57381(ModDataComponents.STARTER_UPGRADES);
        }
        if (stack.method_57826(ModDataComponents.FLUID_TANKS_OLD)) {
            class_1799 oldTanks = ModItems.TANKS_UPGRADE.method_7854();
            oldTanks.method_57379(ModDataComponents.FLUIDS, (Object)new Fluids(new FluidVariantWrapper(((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).leftTank().fluidVariant(), ((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).leftTank().amount()), new FluidVariantWrapper(((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).rightTank().fluidVariant(), ((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).rightTank().amount())));
            this.setStarterUpgrade(oldTanks);
            stack.method_57381(ModDataComponents.FLUID_TANKS_OLD);
        }
    }

    public void setBackpackStack(class_1799 backpack) {
        this.stack = backpack;
        this.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> tanksUpgrade.syncClients(backpack));
    }

    public class_1799 getBackpackStack() {
        return this.stack;
    }

    public int getBackpackSlotIndex() {
        return this.index;
    }

    public void setBackpackOwner(class_1657 player) {
        this.owner = player;
    }

    @Nullable
    public class_1657 getBackpackOwner() {
        return this.owner;
    }

    public ArrayList<class_1657> getPlayersUsing() {
        return this.playersUsing;
    }

    public void addUser(class_1657 player) {
        if (!this.playersUsing.contains(player)) {
            this.playersUsing.add(player);
        }
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public void loadHandler(class_9331<BackpackContainerContents> data, int defaultSize, ItemStackHandler ... handlers) {
        if (this.stack.method_57826(data)) {
            BackpackContainerContents contents = (BackpackContainerContents)this.stack.method_57824(data);
            if (contents.getItems().size() < defaultSize) {
                contents = this.expandContents(contents, defaultSize, this.stack, data);
            }
            for (ItemStackHandler handler : handlers) {
                handler.deserializeNBT(this.registriesAccess, contents.toNbt(this.registriesAccess));
            }
        }
    }

    public void loadHandlers() {
        if (this.dataLoad[0] == 1) {
            this.loadStorage();
        }
        if (this.dataLoad[1] == 1) {
            this.loadUpgrades();
        }
        if (this.dataLoad[2] == 1) {
            this.loadTools();
        }
    }

    public void loadStorage() {
        this.loadHandler(ModDataComponents.BACKPACK_CONTAINER, this.getStorageSize(), this.inventory);
    }

    public void loadUpgrades() {
        this.loadHandler(ModDataComponents.UPGRADES, this.getUpgradesSize(), this.upgrades, this.upgradesTracker);
    }

    public void loadTools() {
        this.loadHandler(ModDataComponents.TOOLS_CONTAINER, this.getToolSize(), this.tools);
    }

    public void loadAdditionally(int type) {
        if (this.dataLoad[type] == 0) {
            if (type == 0) {
                this.loadStorage();
            }
            if (type == 1) {
                this.loadUpgrades();
            }
            if (type == 2) {
                this.loadTools();
            }
            this.dataLoad[type] = 1;
        }
    }

    public BackpackContainerContents expandContents(BackpackContainerContents contents, int size, class_1799 backpack, class_9331 type) {
        if (contents.getItems().size() < size) {
            class_2371<class_1799> oldItems = contents.getItems();
            ArrayList<class_1799> itemList = new ArrayList<class_1799>(Collections.nCopies(size, class_1799.field_8037));
            for (int i = 0; i < oldItems.size(); ++i) {
                if (((class_1799)oldItems.get(i)).method_7960()) continue;
                itemList.set(i, (class_1799)oldItems.get(i));
            }
            BackpackContainerContents expandedContents = BackpackContainerContents.fromItems(size, itemList);
            backpack.method_57379(type, (Object)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setStarterUpgrade(class_1799 upgrade) {
        if (this.level == null) {
            return;
        }
        if (upgrade.method_7909().method_45382(this.level.method_45162())) {
            for (int i = 0; i < this.upgrades.getSlots(); ++i) {
                if (!this.upgrades.getStackInSlot(i).method_7960()) continue;
                this.upgrades.setStackInSlot(i, upgrade);
                this.upgradesTracker.setStackInSlot(i, upgrade);
                if (!(upgrade.method_7909() instanceof TanksUpgradeItem)) break;
                this.setRenderInfo(TanksUpgradeItem.writeToRenderData().compoundTag());
                break;
            }
        }
    }

    public int getStorageSize() {
        return (Integer)this.stack.method_57825(ModDataComponents.STORAGE_SLOTS, (Object)Tiers.LEATHER.getStorageSlots());
    }

    public int getUpgradesSize() {
        return (Integer)this.stack.method_57825(ModDataComponents.UPGRADE_SLOTS, (Object)Tiers.LEATHER.getUpgradeSlots());
    }

    public int getToolSize() {
        return (Integer)this.stack.method_57825(ModDataComponents.TOOL_SLOTS, (Object)Tiers.LEATHER.getToolSlots());
    }

    public ItemStackHandler getStorage() {
        return this.inventory;
    }

    public ItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public ItemStackHandler getTools() {
        return this.tools;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public class_7225.class_7874 getRegistriesAccess() {
        return this.registriesAccess;
    }

    public List<Integer> getUnsortableSlots() {
        return ((Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY)).unsortables();
    }

    public List<Pair<Integer, Pair<class_1799, Boolean>>> getMemorySlots() {
        return ((Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY)).memory();
    }

    public int getScreenID() {
        return this.screenID;
    }

    public class_2561 getBackpackScreenTitle() {
        return this.stack.method_57826(class_9334.field_49631) ? (class_2561)this.stack.method_57824(class_9334.field_49631) : class_2561.method_43471((String)"screen.travelersbackpack.title");
    }

    public void setUnsortableSlots(List<Integer> unsortables) {
        Slots old = (Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY);
        this.setData(ModDataComponents.SLOTS, Slots.updateUnsortables(old, unsortables));
    }

    public void setMemorySlots(List<Pair<Integer, Pair<class_1799, Boolean>>> memory) {
        Slots old = (Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY);
        this.setData(ModDataComponents.SLOTS, Slots.updateMemory(old, memory));
    }

    public <T> void setDataAndSync(class_9331<T> dataComponentType, T value) {
        this.setData(dataComponentType, value);
        this.sendDataToClients(dataComponentType);
    }

    public <T> void setData(class_9331<T> dataComponentType, T value) {
        this.stack.method_57379(dataComponentType, value);
        this.saveHandler.run();
        if (dataComponentType == ModDataComponents.ABILITY_ENABLED) {
            this.abilityHandler.run();
        }
    }

    public boolean showToolSlots() {
        return (Boolean)this.stack.method_57825(ModDataComponents.SHOW_TOOL_SLOTS, (Object)false);
    }

    public boolean showMoreButtons() {
        return (Boolean)this.stack.method_57825(ModDataComponents.SHOW_MORE_BUTTONS, (Object)false);
    }

    public boolean tanksVisible() {
        if (this.stack.method_57826(ModDataComponents.RENDER_INFO)) {
            return ((RenderInfo)this.stack.method_57824(ModDataComponents.RENDER_INFO)).hasTanks();
        }
        return this.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent();
    }

    public long getBackpackTankCapacity() {
        return this.tanksCapacity;
    }

    public void setBackpackPos(class_2338 pos) {
        this.backpackPos = pos;
    }

    public class_2338 getBackpackPos() {
        return this.backpackPos;
    }

    public void setBackpackTankCapacity() {
        int rows = this.getRows() + (this.isExtended() ? 2 : 0);
        this.tanksCapacity = Tiers.of((Integer)this.stack.method_57825(ModDataComponents.TIER, (Object)0)).getTankCapacityPerRow() * (long)rows;
    }

    public RenderInfo getRenderInfo() {
        return (RenderInfo)this.stack.method_57825(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY);
    }

    public void setRenderInfo(class_2487 compound) {
        this.setDataAndSync(ModDataComponents.RENDER_INFO, new RenderInfo(compound));
    }

    public void removeRenderInfo() {
        this.setRenderInfo(new class_2487());
    }

    public boolean isAbilityEnabled() {
        return (Boolean)this.stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled);
    }

    public boolean hasSleepingBag() {
        return this.stack.method_57826(ModDataComponents.SLEEPING_BAG_COLOR);
    }

    public int getSleepingBagColor() {
        return (Integer)this.stack.method_57825(ModDataComponents.SLEEPING_BAG_COLOR, (Object)-1);
    }

    public void setSleepingBagColor(int colorId) {
        this.setData(ModDataComponents.SLEEPING_BAG_COLOR, colorId);
    }

    public boolean isOwner(class_1657 player) {
        if (this.getBackpackOwner() != null) {
            return this.getBackpackOwner().method_5628() == player.method_5628();
        }
        return true;
    }

    public boolean isDyed() {
        return this.stack.method_57826(class_9334.field_49644);
    }

    public int getDyeColor() {
        return ((class_9282)this.stack.method_57825(class_9334.field_49644, (Object)new class_9282(-1, false))).comp_2384();
    }

    public int getCooldown() {
        return (Integer)this.stack.method_57825(ModDataComponents.COOLDOWN, (Object)0);
    }

    public void setCooldown(int cooldownInSeconds) {
        this.setDataAndSync(ModDataComponents.COOLDOWN, cooldownInSeconds);
    }

    public void decreaseCooldown() {
        if (this.getCooldown() > 0) {
            this.stack.method_57368(ModDataComponents.COOLDOWN, (Object)0, currentCooldown -> currentCooldown - 1);
            this.saveHandler.run();
        }
    }

    public boolean canUpgradeTick() {
        return this.stack.method_57826(ModDataComponents.UPGRADE_TICK_INTERVAL);
    }

    public boolean hasTickingUpgrade() {
        return this.upgradeManager.hasTickingUpgrade();
    }

    public int getUpgradeTickInterval() {
        return (Integer)this.stack.method_57825(ModDataComponents.UPGRADE_TICK_INTERVAL, (Object)100);
    }

    public void setUpgradeTickInterval(int ticks) {
        this.setDataAndSync(ModDataComponents.UPGRADE_TICK_INTERVAL, ticks);
    }

    public void removeUpgradeTickInterval() {
        this.stack.method_57381(ModDataComponents.UPGRADE_TICK_INTERVAL);
    }

    public boolean isExtended() {
        return this.getStorageSize() > 81;
    }

    public int getSlotsInRow() {
        if (this.isExtended()) {
            return 11;
        }
        return 9;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getStorageSize() / (double)this.getSlotsInRow());
    }

    public void sendDataToClients(class_9331 ... dataComponentTypes) {
        if (this.getScreenID() == 3) {
            return;
        }
        if (this.getScreenID() == 1 && !this.getPlayersUsing().stream().filter(p -> !p.method_37908().field_9236).toList().isEmpty()) {
            int slotIndex = this.index == -1 ? this.getPlayersUsing().get((int)0).method_31548().field_7545 : this.index;
            PacketDistributor.sendToPlayer((class_3222)this.getPlayersUsing().get(0), new ClientboundSyncItemStackPacket(this.getPlayersUsing().get(0).method_5628(), slotIndex, this.getBackpackStack(), ItemStackUtils.createDataComponentMap(this.getBackpackStack(), dataComponentTypes)));
            return;
        }
        if (TravelersBackpack.enableIntegration()) {
            if (this.getScreenID() == 2 && !this.getPlayersUsing().stream().filter(p -> !p.method_37908().field_9236).toList().isEmpty()) {
                for (class_1657 player : this.getPlayersUsing()) {
                    PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), -1, this.getBackpackStack(), ItemStackUtils.createDataComponentMap(this.getBackpackStack(), dataComponentTypes)));
                }
            }
            return;
        }
        if (this.getBackpackOwner() != null) {
            class_9323.class_9324 mapBuilder = class_9323.method_57827();
            class_1799 serverDataHolder = ComponentUtils.getWearingBackpack(this.getBackpackOwner()).method_7972();
            for (class_9331 type : dataComponentTypes) {
                class_1799 serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
                if (!serverDataHolderCopy.method_57826(type)) continue;
                mapBuilder.method_57840(type, serverDataHolderCopy.method_57824(type));
            }
            ComponentUtils.getComponent(this.getBackpackOwner()).ifPresent(data -> data.synchronise(mapBuilder.method_57838()));
        }
    }

    public Optional<Pair<Integer, Pair<class_1799, Boolean>>> getMemorizedSlot(int slot) {
        return this.getMemorySlots().stream().filter(pair -> (Integer)pair.getFirst() == slot).findFirst();
    }

    private ItemStackHandler createHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            @Override
            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (dataId == 2) {
                    BackpackWrapper.this.sendDataToClients(ModDataComponents.TOOLS_CONTAINER);
                }
                BackpackWrapper.this.saveHandler.run();
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                if (dataId == 2) {
                    return ToolSlotItemHandler.isValid(stack);
                }
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }

    public void setSlotChanged(int index, class_1799 stack, int dataId) {
        switch (dataId) {
            case 0: {
                this.stack.method_57367(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(this.getStorage().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 1: {
                this.stack.method_57367(ModDataComponents.UPGRADES, (Object)new BackpackContainerContents(this.getUpgrades().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 2: {
                this.stack.method_57367(ModDataComponents.TOOLS_CONTAINER, (Object)new BackpackContainerContents(this.getTools().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
            }
        }
    }

    public void applyLowestTickInterval() {
        int minimalTickInterval = 100;
        for (int i = 0; i < this.upgrades.getSlots(); ++i) {
            class_1799 upgrade = this.upgrades.getStackInSlot(i);
            if (upgrade.method_7960() || !((Boolean)upgrade.method_57825(ModDataComponents.UPGRADE_ENABLED, (Object)true)).booleanValue() || !upgrade.method_57826(ModDataComponents.COOLDOWN)) continue;
            minimalTickInterval = Math.min(minimalTickInterval, (Integer)upgrade.method_57824(ModDataComponents.COOLDOWN));
        }
        if (!this.canUpgradeTick() || minimalTickInterval != this.getUpgradeTickInterval()) {
            this.setUpgradeTickInterval(minimalTickInterval);
        }
    }

    public void updateMinimalTickInterval(class_1799 newStack) {
        if (this.level != null && this.level.field_9236) {
            return;
        }
        boolean applyLowestTickInterval = false;
        class_1792 class_17922 = newStack.method_7909();
        if (class_17922 instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)class_17922;
            if (upgradeItem.isTickingUpgrade()) {
                if (((Boolean)newStack.method_57825(ModDataComponents.UPGRADE_ENABLED, (Object)true)).booleanValue()) {
                    int tickInterval = this.getUpgradeTickInterval();
                    if (newStack.method_57826(ModDataComponents.COOLDOWN)) {
                        tickInterval = (Integer)newStack.method_57824(ModDataComponents.COOLDOWN);
                    }
                    if (!this.canUpgradeTick() || tickInterval < this.getUpgradeTickInterval()) {
                        this.setUpgradeTickInterval(tickInterval);
                    } else if (tickInterval > this.getUpgradeTickInterval()) {
                        applyLowestTickInterval = true;
                    }
                } else {
                    applyLowestTickInterval = true;
                }
            }
        } else {
            applyLowestTickInterval = true;
        }
        if (this.canUpgradeTick()) {
            if (!this.hasTickingUpgrade()) {
                this.removeUpgradeTickInterval();
            } else if (applyLowestTickInterval) {
                this.applyLowestTickInterval();
            }
        }
    }

    private ItemStackHandler createUpgradeHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            @Override
            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (!BackpackWrapper.this.getPlayersUsing().isEmpty()) {
                    BackpackWrapper.this.getUpgradeManager().detectedChange(BackpackWrapper.this.upgradesTracker, slot);
                }
                BackpackWrapper.this.updateMinimalTickInterval(this.getStackInSlot(slot));
                BackpackWrapper.this.saveHandler.run();
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                boolean isValid = true;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).method_7909() != stack.method_7909()) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                if (stack.method_7909() instanceof TanksUpgradeItem) {
                    isValid = TanksUpgradeItem.canBePutInBackpack(BackpackWrapper.this.getBackpackTankCapacity(), stack);
                }
                if (!this.checkIfUpgradeValid(stack)) {
                    isValid = false;
                }
                return isValid;
            }

            public boolean checkIfUpgradeValid(class_1799 upgradeStack) {
                class_1792 class_17922 = upgradeStack.method_7909();
                if (class_17922 instanceof UpgradeItem) {
                    class_1657 player;
                    UpgradeItem upgradeItem = (UpgradeItem)class_17922;
                    class_1657 class_16572 = player = BackpackWrapper.this.getPlayersUsing().isEmpty() ? null : BackpackWrapper.this.getPlayersUsing().getFirst();
                    if (player == null) {
                        return false;
                    }
                    return upgradeItem.method_45382(player.method_37908().method_45162());
                }
                return false;
            }
        };
    }

    public static boolean isSizeInitialized(class_1799 stack) {
        return stack.method_57826(ModDataComponents.STORAGE_SLOTS) && stack.method_57826(ModDataComponents.UPGRADE_SLOTS) && stack.method_57826(ModDataComponents.TOOL_SLOTS);
    }

    public static void initializeSize(class_1799 stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        if (stack.method_57826(ModDataComponents.TIER)) {
            tier = Tiers.of((Integer)stack.method_57824(ModDataComponents.TIER));
        }
        if (!stack.method_57826(ModDataComponents.STORAGE_SLOTS)) {
            stack.method_57379(ModDataComponents.STORAGE_SLOTS, (Object)tier.getStorageSlots());
        }
        if (!stack.method_57826(ModDataComponents.UPGRADE_SLOTS)) {
            stack.method_57379(ModDataComponents.UPGRADE_SLOTS, (Object)tier.getUpgradeSlots());
        }
        if (!stack.method_57826(ModDataComponents.TOOL_SLOTS)) {
            stack.method_57379(ModDataComponents.TOOL_SLOTS, (Object)tier.getToolSlots());
        }
    }

    public void requestMenuAndScreenUpdate() {
        this.requestMenuUpdate();
        this.requestScreenUpdate();
    }

    public void requestMenuUpdate() {
        if (!this.getPlayersUsing().isEmpty()) {
            this.getPlayersUsing().stream().filter(player -> player.field_7512 instanceof BackpackBaseMenu).forEach(player -> ((BackpackBaseMenu)player.field_7512).updateModifiableSlots());
        }
    }

    public void requestScreenUpdate() {
        class_437 class_4372;
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.method_37908().field_9236).toList().isEmpty() && (class_4372 = class_310.method_1551().field_1755) instanceof BackpackScreen) {
            BackpackScreen screen = (BackpackScreen)class_4372;
            screen.updateScreen(false);
        }
    }

    public static void tickForBlockEntity(BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
        if (wrapper != DUMMY && wrapper.isAbilityEnabled() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, wrapper.getBackpackStack())) {
            boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickBlock(backpackBlockEntity);
            if (wrapper.getCooldown() > 0 && decreaseCooldown) {
                wrapper.decreaseCooldown();
            }
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 backpack, int[] dataLoad) {
        if (ComponentUtils.isWearingBackpack(player)) {
            BackpackItemMenu menu;
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof BackpackItemMenu && (menu = (BackpackItemMenu)class_17032).getWrapper().getScreenID() == 2) {
                return menu.getWrapper();
            }
            for (class_1657 otherPlayer : player.method_37908().method_18456()) {
                BackpackItemMenu menu2;
                class_1703 class_17033 = otherPlayer.field_7512;
                if (!(class_17033 instanceof BackpackItemMenu) || !(menu2 = (BackpackItemMenu)class_17033).getWrapper().isOwner(player) || menu2.getWrapper().getScreenID() != 2) continue;
                return menu2.getWrapper();
            }
            return new BackpackWrapper(backpack, 2, (class_7225.class_7874)player.method_37908().method_30349(), player, player.method_37908(), dataLoad);
        }
        return null;
    }

    public static void tick(class_1799 stack, class_1657 player, boolean integration) {
        if (!integration && TravelersBackpack.enableIntegration()) {
            return;
        }
        if (player.method_5805() && ComponentUtils.isWearingBackpack(player)) {
            BackpackWrapper wrapper;
            int ticks = (int)player.method_37908().method_8510();
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
                if (BackpackAbilities.isAbilityEnabledInConfig(stack)) {
                    if (((Boolean)stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled)).booleanValue()) {
                        boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTick(stack, player);
                        if ((Integer)stack.method_57825(ModDataComponents.COOLDOWN, (Object)0) > 0 && ticks % 100 == 0 && decreaseCooldown) {
                            wrapper = ComponentUtils.getBackpackWrapper(player, stack, ComponentUtils.NO_ITEMS);
                            int cooldown = wrapper.getCooldown();
                            if (player.method_37908().field_9236) {
                                return;
                            }
                            if (cooldown - 100 < 0) {
                                wrapper.setCooldown(0);
                            } else {
                                wrapper.setCooldown(cooldown - 100);
                            }
                        }
                    } else if ((Integer)stack.method_57825(ModDataComponents.COOLDOWN, (Object)0) > 0 && ticks % 100 == 0) {
                        BackpackWrapper wrapper2 = ComponentUtils.getBackpackWrapper(player, stack, ComponentUtils.NO_ITEMS);
                        int cooldown = wrapper2.getCooldown();
                        if (player.method_37908().field_9236) {
                            return;
                        }
                        if (cooldown - 100 < 0) {
                            wrapper2.setCooldown(0);
                        } else {
                            wrapper2.setCooldown(cooldown - 100);
                        }
                    }
                }
            } else if (((Boolean)stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)false)).booleanValue()) {
                stack.method_57379(ModDataComponents.ABILITY_ENABLED, (Object)false);
            }
            if (stack.method_57826(ModDataComponents.UPGRADE_TICK_INTERVAL)) {
                int upgradeTicks = (Integer)stack.method_57824(ModDataComponents.UPGRADE_TICK_INTERVAL);
                if (upgradeTicks == 0) {
                    return;
                }
                if (ticks % upgradeTicks == 0) {
                    wrapper = ComponentUtils.getBackpackWrapper(player, stack, ComponentUtils.UPGRADES_ONLY);
                    wrapper.getUpgradeManager().upgrades.forEach(upgradeBase -> {
                        if (upgradeBase instanceof ITickableUpgrade) {
                            ITickableUpgrade tickable = (ITickableUpgrade)((Object)upgradeBase);
                            boolean tick = true;
                            if (upgradeBase instanceof IEnable) {
                                IEnable enable = (IEnable)((Object)upgradeBase);
                                tick = enable.isEnabled((UpgradeBase<?>)upgradeBase);
                            }
                            if (tick) {
                                tickable.tick(player, player.method_37908(), player.method_24515(), ticks);
                            }
                        }
                    });
                }
            }
        }
    }
}

